/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.controller;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.wanzhuan.base.vo.RdPage;
import com.bxm.newidea.wanzhuan.points.domain.AmountRewardMapper;
import com.bxm.newidea.wanzhuan.points.domain.UserRewardStatMapper;
import com.bxm.newidea.wanzhuan.points.vo.AmountReward;
import com.bxm.newidea.wanzhuan.points.vo.RateDarilyBto;
import com.bxm.newidea.wanzhuan.points.vo.RateDarilyDTO;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/admin/rate"})
public class AdminRateController {
    @Resource
    private UserRewardStatMapper userRewardStatMapper;
    @Resource
    private AmountRewardMapper amountRewardMapper;

    @RequestMapping(value={"queryRateList"}, method={RequestMethod.GET})
    public Object getActivityList(RateDarilyDTO rateDarilyDTO) {
        RdPage rdPage = new RdPage();
        rdPage.setCurPage(rateDarilyDTO.getCurPage().intValue());
        rdPage.setPageSize(rateDarilyDTO.getPageSize().intValue());
        rdPage.setItemTotal((long)this.userRewardStatMapper.getRateDarilyCount(rateDarilyDTO));
        List rateDarilyBtoList = this.userRewardStatMapper.getRateDarilyByParams(rateDarilyDTO);
        if (!ObjectUtils.isEmpty((Object)rateDarilyBtoList)) {
            for (RateDarilyBto rateDarilyBto : rateDarilyBtoList) {
                if (rateDarilyBto.getGold().compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal rate = rateDarilyBto.getMoney().divide(rateDarilyBto.getGold(), 2, 1);
                rateDarilyBto.setRate(rate + "%");
            }
            return ResultUtil.genSuccessResultWithPage((Object)rateDarilyBtoList, (RdPage)rdPage);
        }
        return ResultUtil.genSuccessResult();
    }

    @RequestMapping(value={"updateAward"}, method={RequestMethod.GET})
    public Object updateAward(AmountReward amountReward) {
        this.amountRewardMapper.updateByPrimaryKeySelective(amountReward);
        return ResultUtil.genSuccessResult();
    }

    @RequestMapping(value={"setAward"}, method={RequestMethod.GET})
    public Object setAward(AmountReward amountReward) {
        this.amountRewardMapper.insertSelective(amountReward);
        return ResultUtil.genSuccessResult();
    }
}

