/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk;

import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public final class KeyValueMap
extends LinkedMultiValueMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueMap.class);
    private static final String[] IMMUTABLE_NAMES = new String[]{"p", "mt"};

    public KeyValueMap() {
    }

    public KeyValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public KeyValueMap(Map<String, List<String>> otherMap) {
        super(otherMap);
    }

    public String createOpenLogRequestUri(String rDomain) {
        return this.createOpenLogRequestUri(rDomain, null);
    }

    public String createOpenLogRequestUri(String rDomain, KeyValueMap customizeParams) {
        String production = this.getProduction();
        if (StringUtils.isBlank((String)production)) {
            throw new NullPointerException("Value is blank of 'production', please set to value like this \"this.put(PublicParam.P, Production.PANGU.getName())\"");
        }
        String url = UriComponentsBuilder.fromUriString((String)rDomain).pathSegment(new String[]{production, "s.gif"}).build().toString();
        return this.toRequestUri(url, customizeParams);
    }

    private String toRequestUri(String url, KeyValueMap customizeParams) {
        final UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)this);
        if (Objects.nonNull((Object)customizeParams)) {
            customizeParams.forEach(new BiConsumer<String, List<String>>(){

                @Override
                public void accept(String s, List<String> strings) {
                    if (Objects.nonNull(strings)) {
                        Object[] array = strings.toArray(new String[0]);
                        builder.replaceQueryParam(s, array);
                    }
                }
            });
        }
        return builder.build().toString();
    }

    public <T> T toSimpleObject(final Class<T> clazz) {
        return this.toSimpleObject(new Function<Map<String, String>, T>(){

            @Override
            public T apply(Map<String, String> stringStringMap) {
                return JsonHelper.convert((byte[])JsonHelper.convert2bytes(stringStringMap), (Class)clazz);
            }
        });
    }

    private <T> T toSimpleObject(Function<Map<String, String>, T> converter) {
        Map single = this.toSingleValueMap();
        return converter.apply(single);
    }

    public String getIp() {
        return (String)this.getFirst("ip");
    }

    public String getUa() {
        return (String)this.getFirst("ua");
    }

    public String getRef() {
        return (String)this.getFirst("refer");
    }

    public String getProduction() {
        return (String)this.getFirst("p");
    }

    public String getMt() {
        return (String)this.getFirst("mt");
    }

    public String defaultIfBlank(String key, String defaultValue) {
        return StringUtils.defaultIfBlank((String)((String)this.getFirst(key)), (String)defaultValue);
    }

    public String defaultIfEmpty(String key, String defaultValue) {
        return StringUtils.defaultIfEmpty((String)((String)this.getFirst(key)), (String)defaultValue);
    }

    public KeyValueMap deepCopy() {
        return this.deepCopy(new String[0]);
    }

    public KeyValueMap deepCopy(String ... withoutKey) {
        KeyValueMap map = new KeyValueMap(this.size());
        this.forEach((key, values) -> {
            if (Objects.isNull(withoutKey) || !ArrayUtils.contains((Object[])withoutKey, (Object)key)) {
                map.put((String)key, (List<String>)new LinkedList<String>((Collection<String>)values));
            }
        });
        return map;
    }

    public List<String> put(String key, Object value) {
        return this.put(key, TypeHelper.castToString((Object)value));
    }

    public List<String> put(String key, String value) {
        return this.put(key, (List<String>)Lists.newArrayList((Object[])new String[]{value}));
    }

    public List<String> put(String key, List<String> value) {
        if (this.containsKey(key) && ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed modify key: " + key);
        }
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        if (Objects.isNull(map)) {
            return;
        }
        Set<? extends String> keySet = map.keySet();
        for (String string : keySet) {
            if (!this.containsKey(string) || !ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)string)) continue;
            map.remove(string);
            if (!log.isWarnEnabled()) continue;
            log.warn("illegal key '{}', cause not allowed!", (Object)string);
        }
        super.putAll(map);
    }

    public List<String> remove(Object key) {
        if (ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key);
    }

    public boolean remove(Object key, Object value) {
        if (ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key, value);
    }
}

