package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * @author allen
 * @date 2022-06-01
 * @since 1.0
 */
public class Adx {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * 请求ADX
         */
        RequestAdx("1"),
        /**
         * 请求DSP
         */
        RequestDsp("2"),
        /**
         * DSP响应
         */
        DspResponse("3"),
        /**
         * ADX响应
         */
        AdxResponse("4"),
        /**
         * 曝光
         */
        Show("5"),
        /**
         * 点击
         */
        Click("6"),
        /**
         * 胜出
         */
        Win("7"),
        /**
         * DeepLink 开始
         */
        DpStart("10"),
        /**
         * DeepLink 成功
         */
        DpSuccess("11"),
        /**
         * DeepLink 失败
         */
        DpFail("12"),
        /**
         * 开始下载
         */
        DownloadStart("15"),
        /**
         * 完成下载
         */
        DownloadFinish("16"),
        /**
         * 开始安装
         */
        InstallStart("17"),
        /**
         * 完成安装
         */
        InstallFinish("18"),;

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Adx.Mt of(String original) {
            Adx.Mt[] values = values();
            for (Adx.Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    public interface Param extends ProductionCommonParam {
        int CHGTYPE_CPM = 1;
        int CHGTYPE_CPC = 2;

        String VER = "ver";
        String TIME = "time";
        String SPM = "spm";
        String BIDID = "bidid";
        String TAGID = "tagid";
        String DTAGID = "dtagid";
        String PRICE = "price";
        String DSPID = "dspid";
        String APPID = "appid";
        String DAPPID = "dappid";
        String DPR = "dpr";
        String MEDID = "medid";
        String CHGTYPM = "chgtypm";
        String CHGTYPD = "chgtypd";

        String WIN_PRICE = "win_price";
        String DSP_PRICE = "dsp_price";
    }
}
