package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
public final class Common {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * oCPX 行为上报
         */
        oCpx_Reporting("1"),

        /**
         * RTB 转化回传
         */
        rtbConversion("2"),

        /**
         * 巨量引擎点击监测（由巨量引擎请求）
         */
        OceanengineClickTracker("10"),

        /**
         * 大航海转化回传（上报大航海时的 callbackUrl）
         */
        DhhConversion("11");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * Rtb 服务商定义
     */
    public enum RtbType {

        /**
         * 快手
         */
        Kuaishou("1"),

        /**
         * Lagesi
         */
        Lagesi("2");

        private final String id;

        RtbType(String id) {
            this.id = id;
        }

        public static RtbType of(String id) {
            RtbType[] values = values();
            for (RtbType value : values) {
                if (value.id.equals(id)) {
                    return value;
                }
            }
            return null;
        }

        public String getId() {
            return id;
        }
    }

    /**
     * Rtb 的参数定义
     */
    public interface RtbParam extends ProductionCommonParam {

        String RTB = "rtb";
        String BXMID = "bxmid";
        String TYPE = "type";
        String UID = "uid";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String IP = "ip";
        String OS = "os";
        String UA = "ua";
        String RTB_REQUEST_URI = "rtb_request_uri";
        String RTB_EVENT_TYPE = "rtb_event_type";
        String RTB_REQ_BODY = "rtb_req_body";
        String RTB_RES_BODY = "rtb_res_body";
        String RTB_RES_MSG = "rtb_res_msg";
    }
}
