package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 算法的常量定义
 *
 * @author daill
 * @date 2023-06-14
 * @since 1.0
 */
public final class Algorithm {

    /**
     * 算法行为类型定义。
     *
     * <a href="https://bxmrds.yuque.com/mizhsy/eqfqab/ec96sh2xb2ig92t0">详情</a>
     *
     * @author daill
     * @date 2023-06-14
     * @since 1.0
     */
    public enum Mt {

        /**
         * 发券算法
         */
        TICKET_ALGO("101"),

        /**
         * 活动算法
         */
        ACTIVITY_ALGO("102");


        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * 算法日志的行为参数。
     *
     * <a href="https://bxmrds.yuque.com/mizhsy/eqfqab/ec96sh2xb2ig92t0">详情</a>
     *
     * @author daill
     * @date 2023-06-14
     * @since 1.0
     */
    public interface Param extends ProductionCommonParam {
        String BXMID = "bxmid";
        String UID = "uid";
        String TAGID = "tagid";
        String TIME = "time";
        String SPM = "spm";
        String SCENE = "scene";
        String CODEIDS = "codeids";
        String BIZTYPE = "biztype";
        String ALGOCONF = "algoconf";
        String ALGOJSON = "algojson";
        String BESTRESULT = "bestresult";
        String VER = "ver";
        String USERDAYBXMIDRANK = "userdayrank";
        String TICKETASSETSID = "ticketassets";
        String ASSETTCTCVR = "assetctcvr";
        String LANDPAGECTCVR = "landpagectcvr";
        String BESTLANDPAGE = "bestlandpage";
    }
}
