/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk;

import com.bxm.openlog.sdk.Production;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public final class KeyValueMap
extends LinkedMultiValueMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueMap.class);
    private static final String[] IMMUTABLE_NAMES = new String[]{"p", "mt"};

    public KeyValueMap() {
    }

    public KeyValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public KeyValueMap(Map<String, List<String>> otherMap) {
        super(otherMap);
    }

    public String createOpenLogRequestUri(String rDomain) {
        return this.createOpenLogRequestUri(rDomain, true);
    }

    public String createOpenLogRequestUri(String rDomain, boolean encode) {
        return this.createOpenLogRequestUri(rDomain, null, encode);
    }

    public String createOpenLogRequestUri(String rDomain, KeyValueMap customizeParams, boolean encode) {
        String production = this.getProduction();
        if (StringUtils.isBlank((String)production)) {
            throw new NullPointerException("Value is blank of 'production', please set to value like this \"this.put(PublicParam.P, Production.PANGU.getName())\"");
        }
        String url = UriComponentsBuilder.fromUriString((String)rDomain).pathSegment(new String[]{production, "s.gif"}).build().toString();
        return this.toRequestUri(url, customizeParams, encode);
    }

    private String toRequestUri(String url, KeyValueMap customizeParams, boolean encode) {
        KeyValueMap target = encode ? this.createNewInstanceOfEncoding(this) : this;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)target);
        if (Objects.nonNull((Object)customizeParams)) {
            KeyValueMap map = encode ? this.createNewInstanceOfEncoding(customizeParams) : customizeParams;
            map.forEach((s, values) -> {
                if (Objects.nonNull(values)) {
                    Object[] array = values.toArray(new String[0]);
                    builder.replaceQueryParam(s, array);
                }
            });
        }
        return builder.build().toString();
    }

    private KeyValueMap createNewInstanceOfEncoding(KeyValueMap source) {
        KeyValueMap target = new KeyValueMap();
        for (Map.Entry entry : source.entrySet()) {
            String key = (String)entry.getKey();
            List strings = (List)entry.getValue();
            for (String string : strings) {
                target.add(key, UrlHelper.urlEncode((String)string));
            }
        }
        return target;
    }

    public <T> T toSimpleObject(final Class<T> clazz) {
        return this.toSimpleObject(new Function<Map<String, String>, T>(){

            @Override
            public T apply(Map<String, String> stringStringMap) {
                return JsonHelper.convert((byte[])JsonHelper.convert2bytes(stringStringMap), (Class)clazz);
            }
        });
    }

    private <T> T toSimpleObject(Function<Map<String, String>, T> converter) {
        Map single = this.toSingleValueMap();
        return converter.apply(single);
    }

    public KeyValueMap setIp(String ip) {
        this.put("ip", ip);
        return this;
    }

    public String getIp() {
        return (String)this.getFirst("ip");
    }

    public KeyValueMap setUa(String ua) {
        this.put("ua", ua);
        return this;
    }

    public String getUa() {
        return (String)this.getFirst("ua");
    }

    public KeyValueMap setRef(String refer) {
        this.put("refer", refer);
        return this;
    }

    public String getRef() {
        return (String)this.getFirst("refer");
    }

    public KeyValueMap setProduction(Production production) {
        Preconditions.checkNotNull((Object)((Object)production));
        this.put("p", production.getName());
        return this;
    }

    public String getProduction() {
        return (String)this.getFirst("p");
    }

    public KeyValueMap setMt(String mt) {
        this.put("mt", mt);
        return this;
    }

    public String getMt() {
        return (String)this.getFirst("mt");
    }

    public KeyValueMap setVersion(String ver) {
        this.put("ver", ver);
        return this;
    }

    public String getVersion() {
        return (String)this.getFirst("ver");
    }

    public String defaultIfBlank(String key, String defaultValue) {
        return StringUtils.defaultIfBlank((String)((String)this.getFirst(key)), (String)defaultValue);
    }

    public String defaultIfEmpty(String key, String defaultValue) {
        return StringUtils.defaultIfEmpty((String)((String)this.getFirst(key)), (String)defaultValue);
    }

    public KeyValueMap deepCopy() {
        return this.deepCopy(new String[0]);
    }

    public KeyValueMap deepCopy(String ... withoutKey) {
        KeyValueMap map = new KeyValueMap(this.size());
        this.forEach((key, values) -> {
            if (Objects.isNull(withoutKey) || !ArrayUtils.contains((Object[])withoutKey, (Object)key)) {
                map.put((String)key, (List<String>)new LinkedList<String>((Collection<String>)values));
            }
        });
        return map;
    }

    public void putIfNotBlank(String key, String value) {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        this.put(key, value);
    }

    public List<String> put(String key, Object value) {
        return this.put(key, TypeHelper.castToString((Object)value));
    }

    public List<String> put(String key, String value) {
        return this.put(key, (List<String>)Lists.newArrayList((Object[])new String[]{value}));
    }

    public List<String> put(String key, List<String> value) {
        if (this.containsKey(key) && ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed modify key: " + key);
        }
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        if (Objects.isNull(map)) {
            return;
        }
        Set<? extends String> keySet = map.keySet();
        for (String string : keySet) {
            if (!this.containsKey(string) || !ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)string)) continue;
            map.remove(string);
            if (!log.isWarnEnabled()) continue;
            log.warn("illegal key '{}', cause not allowed!", (Object)string);
        }
        super.putAll(map);
    }

    public List<String> remove(Object key) {
        if (ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key);
    }

    public boolean remove(Object key, Object value) {
        if (ArrayUtils.contains((Object[])IMMUTABLE_NAMES, (Object)key)) {
            throw new UnsupportedOperationException("Not allowed remove key: " + key);
        }
        return super.remove(key, value);
    }
}

