package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
public final class Common {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * oCPX 行为上报
         */
        oCpx_Reporting("1"),

        /**
         * RTB 转化回传
         */
        rtbConversion("2"),

        /**
         * RTB 扣量
         */
        rtbDeduction("3"),

        /**
         * RTB 智能回传
         */
        RtbSmartConversion("4"),

        /**
         * RTB 获取广告组数据日志
         */
        RtbAdGroupDataFetch("5"),

        /**
         * RTB获取广告数据日志
         */
        RtbAdDataFetch("6"),

        /**
         * RTB累加CPA数据日志
         */
        RtbSummaryCpa("7"),

        /**
         * RTB广告账户花费日志
         */
        RtbAdvertiserCost("8"),

        /**
         * 巨量引擎点击监测（由巨量引擎请求）
         */
        OceanengineClickTracker("10"),

        /**
         * 大航海转化回传（上报大航海时的 callbackUrl）
         */
        DhhConversion("11"),

        /**
         * 通用的媒体点击监测
         */
        oCpxClickTrackerForCommon("20"),
        /**
         * 通用的广告主转化回传
         */
        oCpxFeedbackForCommon("21"),

        /**
         * RTB 平台点击监测
         */
        ClickTrackerForRtb("30"),

        /**
         * Rta-Api接口请求
         */
        RtaApiRequest("50"),

        /**
         * 海外广告点击埋点
         */
        OverseasClick("60"),

        /**
         * 海外广告回传埋点
         */
        OverseasConversion("61"),

        /**
         * 海外广告主回传请求 (广告主使用)
         */
        OverseasFeedbackRequest("62"),

        /**
         * 优酷权益领取埋点
         */
        YoukuActivity("70"),

        /**
         * 短信运营商埋点
         */
        Sms_Captcha("71"),

        /**
         * 新abtest平台埋点
         */
        Abtest("110");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * Rtb 服务商定义
     */
    @Deprecated
    public enum RtbType {

        /**
         * 快手
         */
        Kuaishou("1"),

        /**
         * Lagesi
         */
        Lagesi("2");

        private final String id;

        RtbType(String id) {
            this.id = id;
        }

        public static RtbType of(String id) {
            RtbType[] values = values();
            for (RtbType value : values) {
                if (value.id.equals(id)) {
                    return value;
                }
            }
            return null;
        }

        public String getId() {
            return id;
        }
    }


    public interface Param extends ProductionCommonParam {
        String BXMID = "bxmid";
        String BXMMEDIA = "bxmmedia";
        String BXMADVERTISER = "bxmadvertiser";
        String CLICK_ID = "click_id";
        String CONV_RATIO = "conv_ratio";
        String CONV_DEF = "conv_def";
        String RTB_ID = "rtb_id";
        String AD_GROUP_ID = "ad_group_id";
        String BXMEXTRA = "bxmextra";
    }

    /**
     * Rtb 的参数定义
     */
    public interface RtbParam extends ProductionCommonParam {

        String RTB = "rtb";
        String BXMID = "bxmid";
        String TYPE = "type";
        String UID = "uid";
        String RTB_STATUS = "rtb_status";
        String ACTION_TIME = "action_time";
        String RANK_BY_ACTIVITY = "rank_by_activity";
        String ACTION_TYPE = "action_type";
        String SMART_CONV_TYPE = "smart_conv_type";
        String RETRY_FLAG = "retry_flag";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String IP = "ip";
        String OS = "os";
        String UA = "ua";
        String RTB_REQUEST_URI = "rtb_request_uri";
        String RTB_EVENT_TYPE = "rtb_event_type";
        String RTB_REQ_BODY = "rtb_req_body";
        String RTB_RES_BODY = "rtb_res_body";
        String RTB_RES_MSG = "rtb_res_msg";
        String FEEDBACK_MODE = "feedback_mode";
    }

    public interface RtaApiParam extends ProductionCommonParam {
        String RTAID = "rta_id";
    }

    public interface AbtestParam extends ProductionCommonParam {
        String EXPERIMENT_ID = "experiment_id";
        String VERSION_CODE = "version_code";
        String BUSINESS_SCENE = "business_scene";
        String BXM_ID = "bxmid";
        String UID = "uid";
        String SPM = "spm";
        String TAG_ID = "tagid";
    }
}
