package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;
import lombok.Getter;

/**
 * @author zhangdong
 * @date 2024/5/28
 */
public final class Music {

    @Getter
    public enum Mt {
        /**
         * 页面曝光
         */
        PAGE_SHOW("1"),
        /**
         * 页面离开
         */
        PAGE_QUIT("2"),
        /**
         * 页面点击
         */
        PAGE_CLICK("3"),
        /**
         * 登录成功
         */
        LOGIN_SUCCESS("4"),
        ;

        private final String original;

        Mt(String original) {
            this.original = original;
        }
    }

    public interface Param extends ProductionCommonParam {
        String USER_ID = "user_id";
        String OS = "os";
        String OS_VER = "os_ver";
        String BRAND = "brand";
        String CHANNEL = "channel";
        String APP_VER = "app_ver";
        String PAGE_ID = "page_id";
        String SONG_ID = "song_id";
        String POP_ID = "pop_id";
        String SCENE_ID = "scene_id";
        String RECOMMEND = "recommend";
        String OPEN_TIME = "open_time";
        String BUTTON_ID = "button_id";
    }
}
