package com.bxm.openlog.sdk.scheduler;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2022-02-09
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = MqFlowControlProperties.PREFIX)
public class MqFlowControlProperties{

    public static final String PREFIX = "mq.flow.control";
    public static final String PROPERTY_ENABLE = PREFIX + "." + "enable";
    /**
     * 控制阈值
     */
    private int threshold = 10000;
    /**
     * 定时任务轮询时间 单位秒
     */
    private int intervalTime = 5;
}
