package com.bxm.adsmanager.model.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/23 20:26
 * 修 改 人：
 * 日 期：
 * 描 述： adsmanager 常用常量
 * 版 本 号： v1
 */
public interface CommonConstant {

    /**
     * 字典表-媒介code标识
     */
    String MEIJIE_CODE = "mj";

    /**
     * 字典表-AEcode标识
     */
    String AE_CODE = "ae";

    /**
     * 字典表-商务code标识
     */
    String BD_CODE = "bd";

    /**
     * 缓存存储默认值
     */
    String CACHE_DEFAULT_VALUE="1";

    /**
     * ADX券的落地页的特定参数名
     */
    String ADX_TICKET_URL_ARGS_NAME = "xid";

    String KUAISHOU_AUTH_URL = "https://developers.e.kuaishou.com/tools/authorize?app_id=165899974&scope=%5B%22ad_query%22%2C%22ad_manage%22%2C%22report_service%22%2C%22account_service%22%2C%22public_dmp_service%22%2C%22public_agent_service%22%2C%22public_account_service%22%5D&oauth_type=advertiser";

    /**
     * 广告位行业开关的key
     *
     * @return
     */
    public static KeyGenerator getKeyGeneratorByPositionDomainiCode() {
        return () -> KeyBuilder.build("AD", "POSITION", "DOMAINCODE");
    }

    public static KeyGenerator getWeiboAppId() {
        return () -> KeyBuilder.build("AD", "POSITION", "WEIBO");
    }
    public static KeyGenerator wbToken() {
        return () -> KeyBuilder.build("kuaishou", "token");
    }

    /**
     * 基础字符
     */
    class BaseCharacter {
        /**
         * 横杆
         */
        public static final String BAR = "-";

        /**
         * 逗号
         */
        public static final String COMMA = ",";

        /**
         * 点
         */
        public static final String SPOT = ".";

        /**
         * 问号
         */
        public static final String QUESTION_MARK = "?";
    }

    /**
     * 规则前缀
     */
    class Rule {
        /**
         * 1：白名单， 2：黑名单
         */
        public static final String POSITION_WHITE_PREFIX = "1";
        public static final String POSITION_BLACK_PREFIX = "2";
    }


    class TicketStatusGroupIdPreFix {
        /**
         * 广告券状态 暂停下的暂停原因前缀
         */
        public static final String PAUSE = "2-";

    }

    class TicketSettleType {
        /**
         * 结算类型
         */
        public static final Short CPC = 1;
        public static final Short CPA = 2;
        public static final Short CPM = 4;
    }

    /**
     * 结算类型枚举
     */
    @Getter
    @AllArgsConstructor
    enum SettleTypeEnum{
        CPC((short)1, "CPC"),
        CPA((short)2, "CPA"),
        CPM((short)4, "CPM"),
        OCPR((short)5, "OCPR"),
        ;

        private Short type;
        private String name;

        public static String getNameBySettleType(Short type) {
            for (SettleTypeEnum settleTypeEnum : SettleTypeEnum.values()) {
                if (settleTypeEnum.getType().equals(type)) {
                    return settleTypeEnum.getName();
                }
            }
            return "";
        }

        public static boolean isOcpr(Short settleType) {
            if (settleType == null) {
                return false;
            }
            return OCPR.type.equals(settleType) ;
        }
    }

    class TicketTag {
        /**
         * 最高级（默认）父ID
         */
        public static final Integer BASIC_PARENT_ID = 0;

        /**
         * 标签类型： 属性/分类/资质
         */
        public static final Integer TAG_TYPE_PROPERTY = 1;
        public static final Integer TAG_TYPE_CLASSIFY = 2;
        public static final Integer TAG_TYPE_APTITUDE = 3;
    }

    class Export {
        /**
         * 返回vo 默认导出属性集合的 方法名
         */
        public static final String DEFAULT_FIELD_METHOD = "getDefaultExportFields";
    }

    class Dictionaries {

        /**
         * 广告券状态词典 ID
         */
        public static final String TICKET_STATUS_GROUP_ID = "adstatus";

        /**
         * 代理下游
         */
        public static final String PROXY_DOWNSTREAM = "downstream";

    }

    class RedisKey {
        /**
         * 广告位权重 / 广告券权重
         */
        public static final String POSITION_WEIGHT_KEY = "AD:WEIGHT:POSITION_MIF:";
        public static final String TICKET_WEIGHT_KEY = "AD:WEIGHT:TICKET_MIF";


    }

    /**
     * 媒体系统类型
     */
    class MediaType {
        public static final String APP = "app";
        public static final String H5 = "h5";
        public static final String WECHAT = "weixin";
    }

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    class StatusType {
        public static final short STATUS_DISABLE = 0;
        public static final short STATUS_ACTIVATE = 1;
        public static final short STATUS_DELETE = 2;
    }


    /**
     * 素材归属的券类型
     */
    class AssetType {
        // 互动广告
        public static final int TICKET_TYPE_INTERACTIVE = 1;
        // 激励视频
        public static final int TICKET_TYPE_INSPIRE_VIDEO = 2;
        // 素材模板素材（活动券或者直投券）
        public static final int TICKET_TYPE_ASSETS_TEMPLATE_ASSETS = 3;
    }

    /**
     * 素材审核状态
     */
    class AssetAuditStatus {
        // 待审核
        public static final short AUDIT_STATUS_WAIT = 1;
        // 审核通过
        public static final short AUDIT_STATUS_PASS = 2;
        // 审核拒绝
        public static final short AUDIT_STATUS_REFUSE = 3;
    }

    /**
     * 素材检查状态
     */
    class AssetCheckStatus {
        // 1已检查
        public static final short CHECK_STATUS_PASS = 1;
        // 2未检查
        public static final short CHECK_STATUS_WAIT = 2;
    }

    /**
     * 素材状态-投放控制。0- 停用、1- 启用 2删除
     */
    class AssetStatus {
        public static final short STATUS_DISABLE = 0;
        public static final short STATUS_ACTIVATE = 1;
        public static final short STATUS_DELETE = 2;
    }

    /**
     * 关闭标识
     */
    class ClosedFlag {
        public static final Integer CLOSED_YES = 1;
        public static final Integer CLOSED_NO = 0;
    }

    /**
     * 开启标识
     */
    class OpenFlag {
        public static final Integer OPEN_YES = 1;
        public static final Integer OPEN_NO = 0;
    }

    /**
     * 操作的平台和方法
     */
    class Opera {

        /**
         * 操作的平台
         */
        public enum Platform {

            /** 广告主后台 */
            ADVERTISER(1, "广告主后台"),

            /** 运营后台 */
            ADSMANAGER(2, "运营后台"),
            ;

            /**
             * 值
             */
            private int type;

            /**
             * 描述
             */
            private String desc;

            Platform(int type, String desc) {
                this.type = type;
                this.desc = desc;
            }

            public int getType() {
                return type;
            }

            public String getDesc() {
                return desc;
            }

            public static Platform get(int type) {
                for (Platform temp : Platform.values()) {
                    if (temp.type == type) {
                        return temp;
                    }
                }
                return null;
            }
        }

        /**
         * 方法
         */
        public enum Method {

            /** 新增 */
            ADD(1, "新增"),

            /** 编辑 */
            EDIT(2, "编辑"),
            ;

            /**
             * 值
             */
            private int type;

            /**
             * 描述
             */
            private String desc;

            Method(int type, String desc) {
                this.type = type;
                this.desc = desc;
            }

            public int getType() {
                return type;
            }

            public String getDesc() {
                return desc;
            }

            public static Method get(int type) {
                for (Method temp : Method.values()) {
                    if (temp.type == type) {
                        return temp;
                    }
                }
                return null;
            }

            public static boolean isEdit(Method method) {
                return EDIT == method;
            }

            public static boolean isAdd(Method method) {
                return ADD == method;
            }

        }

    }


    /**
     * 环境配置
     */
    class Environment {

        /**
         * 开发环境
         */
        public static final String PROFILES_DEV = "dev";

        /**
         * 测试环境
         */
        public static final String PROFILES_TEST = "test";
    }

    /**
     * 网络类型枚举
     */
    @AllArgsConstructor
    @Getter
    enum NetworkType {
        WIFI("Wi-Fi", "1"),
        _5G("5G", "5"),
        _4G("4G", "4"),
        _3G("3G", "3"),
        _2G("2G", "2"),
        UNKNOWN("未知", "0"),;
        private String name;
        private String type;
        public static String getNamesByTypes(String types) {
            if (StringUtils.isNotBlank(types)) {
                String[] typeArray = types.split(BaseCharacter.COMMA);
                for (int i = 0; i < typeArray.length; i++) {
                    typeArray[i] = getNameByType(typeArray[i]);
                }
                return StringUtils.join(typeArray, BaseCharacter.COMMA);
            }
            return "";
        }

        public static String getNameByType(String type) {
            for (NetworkType network : values()) {
                if (network.type.equals(type)) {
                    return network.getName();
                }
            }
            return "";
        }
    }

    /**
     * 网络类型枚举
     */
    @AllArgsConstructor
    @Getter
    enum PhoneBrandType {
        XIAOMI("小米", "xiaomi"),
        HUAWEI("华为", "huawei"),
        APPLE("苹果", "apple"),
        OPPO("OPPO", "oppo"),
        SAMSUNG("三星", "samsung"),
        VIVO("Vivo", "vivo"),
        MEIZU("魅族", "meizu"),;
        private String name;
        private String type;
        public static String getNamesByTypes(String types) {
            if (StringUtils.isNotBlank(types)) {
                String[] typeArray = types.split(BaseCharacter.COMMA);
                for (int i = 0; i < typeArray.length; i++) {
                    typeArray[i] = getNameByType(typeArray[i]);
                }
                return StringUtils.join(typeArray, BaseCharacter.COMMA);
            }
            return "";
        }

        public static String getNameByType(String type) {
            for (PhoneBrandType phoneBrand : values()) {
                if (phoneBrand.type.equals(type)) {
                    return phoneBrand.getName();
                }
            }
            return "";
        }
    }
}
