package com.bxm.adsmanager.model.constant;

import java.util.List;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;

/**
 * @author yirenjie
 * createDate:  2018/7/17
 */
public class RedisKeys {
    private static final String SYS_TAG = "ADSMANAGER_";

    public static final String AD_POSITION_CONFIG = "AD_POSITION_CONFIG_%s";    // 广告位配置
    public static final String ALARM_MSG_UNREAD = "ALARM_MSG_UNREAD_%s";    // 预警未读消息 username

    public static String getKey(String key, Object... args) {
        return String.format(SYS_TAG + key, args);
    }
    public static final String AD_POSITION_UV_ = "AD:POSITION:UV:";    // 广告位每天活动首页UV

    /**
     * 获取广告位代号的key
     */
    public static KeyGenerator getPositionCodeKey() {
        return () -> KeyBuilder.build("AD", "POSITION", "CODE");
    }

    /**
     * 广告位是开关的key
     *
     * @return
     */
    public static KeyGenerator getKeyGeneratorByPositionStatusSwitch() {
        return () -> KeyBuilder.build("AD", "MEDIA", "POSITION", "SWITCH_STATUS_IN_CLOSING");
    }

    /**
     *拼多多的券
     */
    public static KeyGenerator getPddTickets(){
        return () -> KeyBuilder.build("AD" ,"PDD","TICKETS");
    }

    public static List<Long> advertisers = Lists.newArrayList(1791L);

    public static KeyGenerator getOwnSiteAdvertiser(){return () -> KeyBuilder.build("ADVERTISER","OWN_SITE_TEMPLATE");}


    /**
     * 优惠票券码code临时Key
     * @param keyName
     * @return
     */
    public static KeyGenerator getKeyGeneratorByTempAssetsCouponsCode(String keyName) {
        return () -> KeyBuilder.build("AD", "TICKET", "COUPON", "CODE", "TEMP", keyName);
    }

    /**
     * 优惠票券码code临时Key所在的DB
     * @return
     */
    public static int getKeyGeneratorByTempAssetsCouponsCodeDBIndex() {
        return 0;
    }

    /**
     * 微信小程序校验文件
     * type=hash
     * @return
     */
    public static KeyGenerator getWechatMiniAppVerify() {
        return () -> KeyBuilder.build("GATEWAY", "WECHAT", "MINIAPP", "VERIFY");
    }

    /**
     * 广告位分类标签 key
     * @return
     */
    public static KeyGenerator getKeyGeneratorByPositionTag() {
        return () -> KeyBuilder.build("ADA", "TAGS");
    }



    public static KeyGenerator keyGeneratorBySenceCode(String  senceCode){
        return () -> KeyBuilder.build("ABTEST","BUSINESS","SCENE",senceCode);
    }

    /**
     * 美团广告券key
     * @return
     */
    public static KeyGenerator getMeituanTicketRedisKey() {
        return () -> KeyBuilder.build("AD", "ADX", "TICKET", "MEITUAN");
    }

    /**
     * ocpc第二阶段券key
     * @return
     */
    public static KeyGenerator getOcpcSecendStageTicket() {
        return () -> KeyBuilder.build("AD", "TICKET", "OCPC", "STAGE");
    }

    /**
     * 盘古qtt--MT--Bidded
     * @return
     */
    public static KeyGenerator getPanguQttBidded() {
        return () -> KeyBuilder.build("AD", "PANGU", "QTT", "BIDDED");
    }

    public static KeyGenerator hashKuaishouAppIdConfig() {
        return () -> KeyBuilder.build("AD", "POSITION", "KUAISHOU");
    }
    public static KeyGenerator hashKuaishouToken() {
        return () -> KeyBuilder.build("kuaishou", "token");
    }


    /**
     * 供adscounter rtb控制使用的缓存
     * @param appKey
     * @return
     */
    public static KeyGenerator hashRtbKuaishouAccessToken(String appKey) {
        return () -> KeyBuilder.build("rtb", "conv", "AK", appKey);
    }

    public static KeyGenerator strRtbAdGroupData(Integer rtbId, String adGroupId) {
        return () -> KeyBuilder.build("rtb", "conv", "RTB_DATA", rtbId, adGroupId);
    }

}
