/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.constant;

import java.math.BigDecimal;

/**
 * 报表常量归集地
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.constant.ReportConstant.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 14:43:00
 * @modifier 阿导
 * @updated 2018-02-27 14:43:00
 */
public class ReportConstant {

    /**
     * 日期
     */
    public static final String DATETIME = "datetime";

    /**
     * json格式字符串
     */
    public static final String JSON = "json";

    /**
     * 页面大小
     */
    public static final String PAGE_SIZE = "pageSize";

    /**
     * 页码
     */
    public static final String PAGE_NUM = "pageNum";

    /**
     * 排序字段
     */
    public static final String SORT_NAME = "sortName";

    /**
     * 排序类型（升序、降序）
     */
    public static final String SORT_TYPE = "sortType";

    /**
     * 关键字
     */
    public static final String KEYWORD = "keyword";

    /**
     * 关键字
     */
    public static final String KEYWORDS = "keywords";

    /**
     * 开始时间
     */
    public static final String START_TIME ="startTime" ;

    /**
     * 结束时间
     */
    public static final String END_TIME ="endTime" ;
    /**
     * 首张弹券
     */
    public static final String SCENE ="scene" ;

    public static final String ACTIVITY_TYPE="activityType";
    public static final String ACTIVITY_PLANNER="activityPlanner";

    public static final String ZERO_S="0";
    public static final String BAR_ZERO_S="-0";
    public static final String ONE_S="1";
    public static final String TWENTY_THREE_S="23";
    public static final String TEN_S="10";
    public static final String DEFAULT_SORT_NAME = "hour";
    public static final String SORT_TYPE_ASC = "asc";
    public static final String SORT_TYPE_DESC = "desc";


    /**
     * pojo
     */
    public static final String SEND_PV_VO="sendPv";
    public static final String CLICK_PV_VO="clickPv";
    public static final String OPEN_PV_VO="openPv";
    public static final String VALID_CLICK_VO="validClick";
    public static final String VALID_CLICK_RATE_VO="validClickRate";
    public static final String CONVERSION_VO="conversion";
    public static final String APPKEY_VO = "appKey";
    public static final String BUSINESS = "business";
    public static final String CERTIFICATEID = "certificateid";

    /**  
    * @Title: MEDIAMSG 
    * @Description:  媒体默认信息
    * @author xavier  
    * @date 2018年3月19日  
    */  
    public static interface MEDIADEFAULTMSG {
    	/** 媒体默认名称 */  
    	public static final String MEDIADEFAULTNAME = "未知媒体";
    	/** 广告位默认名称 */  
    	public static final String POSITIONDEFAULTNAME = "未知广告位";
    	/** 默认arpu */  
    	public static final BigDecimal DEFAULTARPU = new BigDecimal(0.0);
    }

}
