package com.bxm.adsmanager.model.dao.adkeeper;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * <h3>广告素材</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 11:27
 */
public class AdAssets implements Serializable {

    private static final long serialVersionUID = -3924001758612736442L;
    public static final int VARS_NO = 0;
    public static final int VARS_PROVINCE = 1;
    public static final int VARS_CITY = 2;

    //1 待审核
    public static final int STATUS_AUDIT_WAIT = 1;
    // 2 审核通过
    public static final int STATUS_AUTDIT_PASS = 2;
    // 3 审核拒绝
    public static final int STATUS_AUTDIT_REFUSE = 3;



    private Long id;//id

    private String name;//素材名称

    @NotNull(message = "素材名称变量不能为空", groups = {AdAssets.Add.class})
    private Integer vars;//素材名称变量。0- 无、1- 省、2- 市

    private String content;//素材内容

    @NotBlank(message = "图片地址不能为空", groups = {AdAssets.Add.class})
    private String image;//图片地址

    @NotBlank(message = "介绍不能为空", groups = {AdAssets.Add.class})
    private String intro;//介绍

    @NotBlank(message = "文案不能为空", groups = {AdAssets.Add.class})
    private String buttonTxt;//文案

    @NotNull(message = "状态不能为空", groups = {AdAssets.Add.class})
    private Short status;//状态
     
    private Integer clickThreshold;//素材点击阀值

    private String createUser;//创建人

    private Date createTime;//创建时间

    private String modifyUser;//修改人

    private Date modifyTime;//修改时间

    private String assetSize;//素材尺寸

    private String assetType;//素材类型

    private String title; //主标题

    private String subtitle;//副标题

    private Integer direct;//是否直投
    
    private String isPopup;//是否屏蔽弹窗(0或者空不屏蔽 ，1屏蔽)

    private Integer auditStatus;//1待审核   2 审核通过  3 审核拒绝

    private  String refuseReason;

    private  String icon;

    /**
     * 素材弹窗id
     */
    private Long assetPopupId;

    /**
     * 动画弹窗参数
     */
    private String dynamicPopupParam;

    /**
     * 流量占比（0-100），仅在素材为手动配置时有效
     */
    private Double flowRate;

    /**
     * 视频
     */
    private String video;

    /**
     * banner
     */
    private String banner;

    public String getIsPopup() {
        return isPopup;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setIsPopup(String isPopup) {
        this.isPopup = isPopup;
    }

    public Integer getDirect() {
        return direct;
    }

    public void setDirect(Integer direct) {
        this.direct = direct;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getAssetSize() {
        return assetSize;
    }

    public void setAssetSize(String assetSize) {
        this.assetSize = assetSize;
    }

    public String getAssetType() {
        return assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == "" ? null : name.trim();
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image == "" ? null : image.trim();
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro == null ? "" : intro.trim();
    }

    
  

    
    /**
     * @return the clickThreshold
     */
    public Integer getClickThreshold() {
        return clickThreshold;
    }

    
    /**
     * @param clickThreshold the clickThreshold to set
     */
    public void setClickThreshold(Integer clickThreshold) {
        this.clickThreshold = clickThreshold;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt == "" ? null : buttonTxt.trim();
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == "" ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Integer getVars() {
        return vars;
    }

    public void setVars(Integer vars) {
        this.vars = vars;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getAssetPopupId() {
        return assetPopupId;
    }

    public void setAssetPopupId(Long assetPopupId) {
        this.assetPopupId = assetPopupId;
    }

    public String getDynamicPopupParam() {
        return dynamicPopupParam;
    }

    public void setDynamicPopupParam(String dynamicPopupParam) {
        this.dynamicPopupParam = dynamicPopupParam;
    }

    public Double getFlowRate() {
        return flowRate;
    }

    public void setFlowRate(Double flowRate) {
        this.flowRate = flowRate;
    }

    public String getVideo() {
        return video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public String getBanner() {
        return banner;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public interface Add{}
    public interface Update{}

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}