package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AdAssetsAdx implements Serializable {

    public final static Short MEITUAN_REVIEW_WAIT = 0;
    public final static Short MEITUAN_REVIEW_PASS = 1;
    public final static Short MEITUAN_REVIEW_REFUSE = 2;


    private static final long serialVersionUID = -3924001758612736442L;
    private Long id;

    /**
     * 票券ID
     */
    private Long adTicketId;

    /**
     * adx配置ID
     */
    private Long adTicketAdxId;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 广告位场景类型
     * @see com.bxm.adsmedia.model.enums.AppEntranceAdxPositionTypeEnum
     */
    private Short positionType;

    /**
     * 广告位类型的描述：多图文、单图文等
     */
    private String positionTypeDesc;

    /**
     * 曝光监测URL
     */
    private String showUrl;

    /**
     * 点击监测URL
     */
    private String clickUrl;

    /**
     * 素材名称
     */
    private String creativeName;

    /**
     * ICON（广告位约束），单个的。
     */
    private String creativeIcon;

    /**
     * 广告标题（广告位约束），单个的。
     */
    private String creativeTitle;

    /**
     * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
     */
    private String creativeContent;

    /**
     * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativePicture;

    /**
     * 广告封面图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativeCover;

    /**
     * 广告视频（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativeVideo;

    /**
     * 视频开始播放地址监测URL
     */
    private String videoPlayStartUrl;

    /**
     * 视频播放完成地址监测URL
     */
    private String videoPlayEndUrl;

    /**
     * 美团审核状态（0.待审核，1.通过 2.拒绝）
     */
    private Short meituanReviewStatus;

    /**
     * 美团审核拒绝原因
     */
    private String meituanRefuseReason;

    /**
     * 审核状态：0- 待提交、1- 提交失败、2- 审核中、3- 审核失败、4- 审核通过
     */
    private Short status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdTicketId() {
        return adTicketId;
    }

    public void setAdTicketId(Long adTicketId) {
        this.adTicketId = adTicketId;
    }

    public Long getAdTicketAdxId() {
        return adTicketAdxId;
    }

    public void setAdTicketAdxId(Long adTicketAdxId) {
        this.adTicketAdxId = adTicketAdxId;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId == null ? null : positionId.trim();
    }

    public Short getPositionType() {
        return positionType;
    }

    public void setPositionType(Short positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc == null ? null : positionTypeDesc.trim();
    }

    public String getShowUrl() {
        return showUrl;
    }

    public void setShowUrl(String showUrl) {
        this.showUrl = showUrl == null ? null : showUrl.trim();
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl == null ? null : clickUrl.trim();
    }

    public String getCreativeName() {
        return creativeName;
    }

    public void setCreativeName(String creativeName) {
        this.creativeName = creativeName == null ? null : creativeName.trim();
    }

    public String getCreativeIcon() {
        return creativeIcon;
    }

    public void setCreativeIcon(String creativeIcon) {
        this.creativeIcon = creativeIcon == null ? null : creativeIcon.trim();
    }

    public String getCreativeTitle() {
        return creativeTitle;
    }

    public void setCreativeTitle(String creativeTitle) {
        this.creativeTitle = creativeTitle == null ? null : creativeTitle.trim();
    }

    public String getCreativeContent() {
        return creativeContent;
    }

    public void setCreativeContent(String creativeContent) {
        this.creativeContent = creativeContent == null ? null : creativeContent.trim();
    }

    public String getCreativePicture() {
        return creativePicture;
    }

    public void setCreativePicture(String creativePicture) {
        this.creativePicture = creativePicture == null ? null : creativePicture.trim();
    }

    public String getCreativeCover() {
        return creativeCover;
    }

    public void setCreativeCover(String creativeCover) {
        this.creativeCover = creativeCover == null ? null : creativeCover.trim();
    }

    public String getCreativeVideo() {
        return creativeVideo;
    }

    public void setCreativeVideo(String creativeVideo) {
        this.creativeVideo = creativeVideo == null ? null : creativeVideo.trim();
    }

    public String getVideoPlayStartUrl() {
        return videoPlayStartUrl;
    }

    public void setVideoPlayStartUrl(String videoPlayStartUrl) {
        this.videoPlayStartUrl = videoPlayStartUrl == null ? null : videoPlayStartUrl.trim();
    }

    public String getVideoPlayEndUrl() {
        return videoPlayEndUrl;
    }

    public void setVideoPlayEndUrl(String videoPlayEndUrl) {
        this.videoPlayEndUrl = videoPlayEndUrl == null ? null : videoPlayEndUrl.trim();
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Short getMeituanReviewStatus() {
        return meituanReviewStatus;
    }

    public void setMeituanReviewStatus(Short meituanReviewStatus) {
        this.meituanReviewStatus = meituanReviewStatus;
    }

    public String getMeituanRefuseReason() {
        return meituanRefuseReason;
    }

    public void setMeituanRefuseReason(String meituanRefuseReason) {
        this.meituanRefuseReason = meituanRefuseReason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }






    /**
     * 状态。0- 待提交、1- 提交失败、2- 审核中、3- 审核失败、4- 审核通过
     */
    public static final short STATUS_NONE = 0;
    public static final short STATUS_SUBMIT_FAIL = 1;
    public static final short STATUS_OPEN = 2;
    public static final short STATUS_AUDIT_FAIL = 3;
    public static final short STATUS_AUDIT_PASS = 4;

    public enum AdAssetsAdxStatus {
        STATUS_NONE (AdAssetsAdx.STATUS_NONE,"待提交"),
        STATUS_SUBMIT_FAIL (AdAssetsAdx.STATUS_SUBMIT_FAIL,"提交失败"),
        STATUS_OPEN (AdAssetsAdx.STATUS_OPEN,"审核中"),
        STATUS_AUDIT_FAIL (AdAssetsAdx.STATUS_AUDIT_FAIL,"审核失败"),
        STATUS_AUDIT_PASS (AdAssetsAdx.STATUS_AUDIT_PASS,"审核通过");

        private short status;
        private String name;

        AdAssetsAdxStatus(short status, String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(short status){
            for (AdAssetsAdx.AdAssetsAdxStatus status1: AdAssetsAdx.AdAssetsAdxStatus.values()){
                if(status==status1.status){
                    return status1.name;
                }
            }
            return "-";
        }

        public short getStatus() {
            return status;
        }

        public String getName() {
            return name;
        }

    }
}