package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import com.bxm.adsmanager.model.constant.CommonConstant;

public class AdAssetsCoupons implements Serializable {

    private static final long serialVersionUID = 2656911409393857623L;

    /**
     * 广告券素材类型：0- 浮标位、1- 展示位
     */
    public static final short TYPE_ICON = 0;
    public static final short TYPE_SHOW = 1;

    private Long id;

    private Long ticketId;

    @NotNull(message = "广告位素材尺寸不能为空", groups = {AdAssetsCoupons.Add.class, AdAssetsCoupons.Update.class})
    private Long positionAssetSizeId;

    @NotNull(message = "广告位素材类型不能为空", groups = {AdAssetsCoupons.Add.class, AdAssetsCoupons.Update.class})
    private Short type;

    private String assetSize;

    @NotNull(message = "广告位素材图不能为空", groups = {AdAssetsCoupons.Add.class, AdAssetsCoupons.Update.class})
    private String image;

    private String image2;

    @NotNull(message = "广告位素材状态不能为空", groups = {AdAssetsCoupons.Add.class, AdAssetsCoupons.Update.class})
    private Short status;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Long getPositionAssetSizeId() {
        return positionAssetSizeId;
    }

    public void setPositionAssetSizeId(Long positionAssetSizeId) {
        this.positionAssetSizeId = positionAssetSizeId;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public String getAssetSize() {
        return assetSize;
    }

    public void setAssetSize(String assetSize) {
        this.assetSize = assetSize == null ? null : assetSize.trim();
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image == null ? null : image.trim();
    }

    public String getImage2() {
        return image2;
    }

    public void setImage2(String image2) {
        this.image2 = image2 == null ? null : image2.trim();
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public interface Add{}
    public interface Update{}

}