package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

/**
 * 激励视频素材
 */
public class AdAssetsInspireVideo implements Serializable {

    private static final long serialVersionUID = 2656911409393857623L;

    // 待审核
    public final static Short AUDIT_STATUS_WAIT = 1;
    // 审核通过
    public final static Short AUDIT_STATUS_PASS = 2;
    // 审核拒绝
    public final static Short AUDIT_STATUS_REFUSE = 3;

    private Long id;

    /**
     * 广告券ID
     */
    private Long ticketId;

    /**
     * 视频
     */
    private String videoUrl;

    /**
     * 视频时长
     */
    private Double videoDuration;

    /**
     * 封面
     */
    private String coverUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subtitle;

    /**
     * ICON
     */
    private String iconUrl;

    /**
     * 按钮
     */
    private String buttonUrl;

    /**
     * 是否有结束页
     */
    private Short endPageFlag;

    /**
     * 结束页轮播图片，多个按英文逗号分隔。允许空元素。如：url,url
     */
    private String endPagePictures;

    /**
     * 结束页按钮
     */
    private String endPageButtonUrl;

    /**
     * 结束页样式：1默认样式，2自定义
     */
    private Short endPageStyleType;

    /**
     * 结束页地址
     */
    private String endPageUrl;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 广告内容
     */
    private String content;

    /**
     * 按钮内容
     */
    private String buttonContent;

    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;


    /**
     * 视频尺寸长度
     */
    private Integer videoHeight;

    /**
     * 视频尺寸宽度
     */
    private Integer videoWidth;

    /**
     * 视频文件大小 单位byte
     */
    private Long videoFileSize;

    /**
     * 1待审核   2 审核通过  3 审核拒绝
     */
    private Short auditStatus;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    private Date createTime;

    private String createUser;

    private Date modifyTime;

    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl == null ? null : videoUrl.trim();
    }

    public Double getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(Double videoDuration) {
        this.videoDuration = videoDuration;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl == null ? null : coverUrl.trim();
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle == null ? null : subtitle.trim();
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl == null ? null : iconUrl.trim();
    }

    public String getButtonUrl() {
        return buttonUrl;
    }

    public void setButtonUrl(String buttonUrl) {
        this.buttonUrl = buttonUrl == null ? null : buttonUrl.trim();
    }

    public Short getEndPageFlag() {
        return endPageFlag;
    }

    public void setEndPageFlag(Short endPageFlag) {
        this.endPageFlag = endPageFlag;
    }

    public String getEndPagePictures() {
        return endPagePictures;
    }

    public void setEndPagePictures(String endPagePictures) {
        this.endPagePictures = endPagePictures == null ? null : endPagePictures.trim();
    }

    public String getEndPageButtonUrl() {
        return endPageButtonUrl;
    }

    public void setEndPageButtonUrl(String endPageButtonUrl) {
        this.endPageButtonUrl = endPageButtonUrl == null ? null : endPageButtonUrl.trim();
    }

    public Short getEndPageStyleType() {
        return endPageStyleType;
    }

    public void setEndPageStyleType(Short endPageStyleType) {
        this.endPageStyleType = endPageStyleType;
    }

    public String getEndPageUrl() {
        return endPageUrl;
    }

    public void setEndPageUrl(String endPageUrl) {
        this.endPageUrl = endPageUrl;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getAssetsName() {
        return assetsName;
    }

    public void setAssetsName(String assetsName) {
        this.assetsName = assetsName;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getButtonContent() {
        return buttonContent;
    }

    public void setButtonContent(String buttonContent) {
        this.buttonContent = buttonContent;
    }

    public Short getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Short videoDirection) {
        this.videoDirection = videoDirection;
    }

    public Short getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Short auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Integer getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    public Integer getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(Integer videoWidth) {
        this.videoWidth = videoWidth;
    }

    public Long getVideoFileSize() {
        return videoFileSize;
    }

    public void setVideoFileSize(Long videoFileSize) {
        this.videoFileSize = videoFileSize;
    }
}