package com.bxm.adsmanager.model.dao.adkeeper;

import java.util.Date;

/**
 * 素材模板素材.</br>
 * Created by zhengwangeng on 2021/6/16
 */
public class AdAssetsTemplateAssets {

    //审核状态：1-无效，2-审核中，3-审核不通过，4-审核通过
    public static final short AUDIT_STATUS_INVALID = 1;
    public static final short AUDIT_STATUS_UNDER_REVIEW = 2;
    public static final short AUDIT_STATUS_REFUSE = 3;
    public static final short AUDIT_STATUS_PASS = 4;

    /**
     * ID
     */
    private Long id;

    /**
     * 广告券ID
     */
    private Long ticketId;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 素材模板ID
     */
    private Long templateId;

    /**
     * 盘古素材库ID,多个用逗号分隔
     */
    private String panguCreativeIds;

    /**
     * 具体素材配置，JSON数组
     */
    private String config;

    /**
     * 1待审核   2 审核通过  3 审核拒绝
     */
    private Short auditStatus;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 检查状态：1已检查，2未检查
     */
    private Short checkStatus;

    /**
     * OPPO审核状态：1-无效，2-审核中，3-审核不通过，4-审核通过
     */
    private Short oppoAuditStatus;

    /**
     * OPPO创意ID
     */
    private String oppoCreativeId;

    /**
     * OPPO审核结果信息
     */
    private String oppoAuditMessage;

    /**
     * ADX审核状态：1-无效，2-审核中，3-审核不通过，4-审核通过
     */
    private Short adxAuditStatus;

    /**
     * ADX创意ID
     */
    private String adxCreativeId;

    /**
     * ADX审核结果信息
     */
    private String adxAuditMessage;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 修改人
     */
    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getAssetsName() {
        return assetsName;
    }

    public void setAssetsName(String assetsName) {
        this.assetsName = assetsName == null ? null : assetsName.trim();
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getPanguCreativeIds() {
        return panguCreativeIds;
    }

    public void setPanguCreativeIds(String panguCreativeIds) {
        this.panguCreativeIds = panguCreativeIds;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config == null ? null : config.trim();
    }

    public Short getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Short auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason == null ? null : refuseReason.trim();
    }

    public Short getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Short checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Short getOppoAuditStatus() {
        return oppoAuditStatus;
    }

    public void setOppoAuditStatus(Short oppoAuditStatus) {
        this.oppoAuditStatus = oppoAuditStatus;
    }

    public String getOppoCreativeId() {
        return oppoCreativeId;
    }

    public void setOppoCreativeId(String oppoCreativeId) {
        this.oppoCreativeId = oppoCreativeId;
    }

    public String getOppoAuditMessage() {
        return oppoAuditMessage;
    }

    public void setOppoAuditMessage(String oppoAuditMessage) {
        this.oppoAuditMessage = oppoAuditMessage;
    }

    public Short getAdxAuditStatus() {
        return adxAuditStatus;
    }

    public void setAdxAuditStatus(Short adxAuditStatus) {
        this.adxAuditStatus = adxAuditStatus;
    }

    public String getAdxCreativeId() {
        return adxCreativeId;
    }

    public void setAdxCreativeId(String adxCreativeId) {
        this.adxCreativeId = adxCreativeId;
    }

    public String getAdxAuditMessage() {
        return adxAuditMessage;
    }

    public void setAdxAuditMessage(String adxAuditMessage) {
        this.adxAuditMessage = adxAuditMessage;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }
}