package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

/**
 * tbl_ad_inner_crowd_package
 * @author
 */
public class AdInnerCrowdPackage implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 人群包名称
     */
    private String name;

    /**
     * 时间范围 1.当天 2.近3天 3.近7天 4.近15天 5.近30天 
     */
    private Byte dateRange;

    /**
     * 已安装app 逗号分隔 100189支付宝/100192微博/100209美团/100303天猫/100251拼多多/100191京东/100310手淘特价/100194闲鱼/100188腾讯新闻/100193淘宝/100359斗鱼/100187UC浏览器/100206百度/1100354飞猪
     */
    private String installedApp;

    /**
     * 预估覆盖量
     */
    private Long predictNum;

    /**
     * 上次数据更新时间（大数据方更新）
     */
    private Date dataUpdateTime;

    /**
     * 创建时间
     */
    private Date createTime;

    private String createUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    private String updateUser;

    /**
     * 是否为初次创建人群包(0:初次，1:非初次)
     */
    private Integer isFirst;

    /**
     * 是否固定的人群包 0:否 1:是
     */
    private Integer isFixed;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * Json扩展配置
     */
    private String jsonConfig;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getDateRange() {
        return dateRange;
    }

    public void setDateRange(Byte dateRange) {
        this.dateRange = dateRange;
    }

    public String getInstalledApp() {
        return installedApp;
    }

    public void setInstalledApp(String installedApp) {
        this.installedApp = installedApp;
    }

    public Long getPredictNum() {
        return predictNum;
    }

    public void setPredictNum(Long predictNum) {
        this.predictNum = predictNum;
    }

    public Date getDataUpdateTime() {
        return dataUpdateTime;
    }

    public void setDataUpdateTime(Date dataUpdateTime) {
        this.dataUpdateTime = dataUpdateTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Integer getIsFirst() {
        return isFirst;
    }

    public void setIsFirst(Integer isFirst) {
        this.isFirst = isFirst;
    }

    public Integer getIsFixed() {
        return isFixed;
    }

    public void setIsFixed(Integer isFixed) {
        this.isFixed = isFixed;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getJsonConfig() {
        return jsonConfig;
    }

    public void setJsonConfig(String jsonConfig) {
        this.jsonConfig = jsonConfig;
    }
}