package com.bxm.adsmanager.model.dao.adkeeper;

import java.util.Date;

public class AdPositionAssetSize {

    /**
     * 广告位类型。0- 浮标位、1- 展示位
     */
    public static final short TYPE_ICON = 0;
    public static final short TYPE_SHOW = 1;

    /**
     * 状态。0- 停用、1- 启用
     */
    public static final short STATUS_DISABLE = 0;
    public static final short STATUS_ACTIVATE = 1;


    private Long id;

    private Short type;

    private Short scaleLength;

    private Short scaleWidth;

    private Integer minLength;

    private Integer minWidth;

    private Integer maxLength;

    private Integer maxWidth;

    private Short status;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getScaleLength() {
        return scaleLength;
    }

    public void setScaleLength(Short scaleLength) {
        this.scaleLength = scaleLength;
    }

    public Short getScaleWidth() {
        return scaleWidth;
    }

    public void setScaleWidth(Short scaleWidth) {
        this.scaleWidth = scaleWidth;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMinWidth() {
        return minWidth;
    }

    public void setMinWidth(Integer minWidth) {
        this.minWidth = minWidth;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMaxWidth() {
        return maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }


    public enum AdPositionAssetSizeType{
        TYPE_ICON (AdPositionAssetSize.TYPE_ICON,"浮标位"),
        TYPE_SHOW  (AdPositionAssetSize.TYPE_SHOW,"展示位");

        private short type;
        private String name;

        AdPositionAssetSizeType(short type,String name){
            this.type = type;
            this.name = name;
        }

        public static String getName(short type){
            for (AdPositionAssetSize.AdPositionAssetSizeType type1: AdPositionAssetSize.AdPositionAssetSizeType.values()){
                if(type == type1.type){
                    return type1.name;
                }
            }
            return "-";
        }

        public short getType() {
            return type;
        }

        public String getName() {
            return name;
        }
    }

    public enum AdPositionAssetSizeStatus{
        STATUS_DISABLE (AdPositionAssetSize.STATUS_DISABLE,"停用"),
        STATUS_ACTIVATE  (AdPositionAssetSize.STATUS_ACTIVATE,"启用");

        private short status;
        private String name;

        AdPositionAssetSizeStatus(short status,String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(short status){
            for (AdPositionAssetSize.AdPositionAssetSizeStatus status1: AdPositionAssetSize.AdPositionAssetSizeStatus.values()){
                if(status == status1.status){
                    return status1.name;
                }
            }
            return "-";
        }

        public short getStatus() {
            return status;
        }

        public String getName() {
            return name;
        }
    }
}