package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * <h3>广告券</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 11:27
 */
public class AdTicket implements Serializable {

    private static final long serialVersionUID = 6872832364266522770L;

    /**
     * 广告券类型。
     */
    public static final short TYPE_NORMALS = 1;
    public static final short TYPE_STANDBYS = 2;
    public static final short TYPE_ENCOURAGE = 3;
    public static final short TYPE_COUPON = 4;
    public static final short TYPE_ADX_DIRECT = 5;
    public static final short TYPE_ADX_INTERACT = 6;
    public static final short TYPE_INSPIRE_VIDEO = 7;
    public static final short TYPE_INSPIRE_VIDEO_STANDBYS = 8;
    public static final short TYPE_DSP = 9;
    public static final short TYPE_RTA = 10;
    public static final short TYPE_PUSH = 11;
    public static final short TYPE_ACTIVITY = 12;
    public static final short TYPE_DIRECT = 13;

    /**
     * 状态。1 正常、2 暂停、3 停止(风控审核通过，运营后台显示待启用)、99 已删除
     * 券上面的投放控制：1开启，3关闭
     */
    public static final short STATUS_OPEN = 1;
    public static final short STATUS_PAUSE = 2;
    public static final short STATUS_CLOSE = 3;
    public static final short STATUS_DELETED = 99;

    //待审核,新建的券默认就是这个状态
    public static final short WAIT_AUDIT = -2;
    //待优化
    public static final short WAIT_OPTIMIZED = -1;
    //审核拒绝
    public static final short AUDIT_REJECTION = -3;
    
    /***
     * 暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束;5-分时段预算不足;99-其它原因
     */
    public static final int PAUSE_EXCESS_BUDGET = 1;
    public static final int PAUSE_NO_BALANCE = 2;
    public static final int PAUSE_DATE_START = 3;
    public static final int PAUSE_DATE_END = 4;
    public static final int PAUSE_EXCESS_HOUR_BUDGET = 5;
    public static final int PAUSE_OTHER = 99;

    public static final short CPC = 1;
    public static final short CPA = 2;
    public static final short CPM = 4;
    public static final short OCPA = 5;
    public static String CPC_ADVERTISER = "广告主更新";

    /**
     * CPC 和 OCPC 最大/最小支持出价的金额
     */
    public static final double CPC_OR_OCPC_MAX_PRICE = 99999.0; //modify by hcmony 20190529
    public static final double CPC_OR_OCPC_MIN_PRICE = 0.001;
    public static final double CPC_MAX_PRICE = 2;

    /**
     * 投放模式：快速
     */
    public static final int CONSUME_MODAL_FAST = 0;
    /**
     * 投放模式：匀速
     */
    public static final int CONSUME_MODAL_AVERAGE = 1;

    private Long id;//id

    private Long ticketId; //直投广告券id

    private String name;//name

    private Long advertiser;//广告主

    private Short settleType;//结算方式：1- CPC、2- CPA、4- CPM 5 OCPA

    private Integer price;//单价

    private Short type;//广告券类型。

    private Long budgetDaily;//日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

    /**
     * 投放方式：0-加速投放、1-匀速投放
     */
    private Integer consumeModal;

    private String domainCode;//所属行业

    private Double standaloneCost;//独立成本。百分比

    private String url;//落地页

    private Date validStartDate;//有效期开始

    private Date validEndDate;//有效期结束

    private Short isSupportWechat;//是否支持微信。0- 不支持、1- 支持

    /**
     * 投放平台
     * @see com.bxm.adsprod.facade.ticket.App
     */
    private String apps;

    private Integer userGradePassScore;//用户评分及格分数线

    private Short status;//状态。0- 暂停、1- 正常、-1 已删除

    private Integer pauseReason;//暂停原因。1- 超出预算、2- 余额不足

    private short isEffectMonitor;     //是否接入效果监控; 1-否 2-接入且精确  3-接入但不准

    private String refuseReason; //审核拒绝原因

    private short lastStatus;//记录状态修改前的正的状态

    private String ae;

    private String urlTestResult;
    /**
     * 分组 ID
     */
    private Long groupId;

    /**
     * 流量包出价配置ID
     */
    private Long flowPackageOfferConfId;

    private String createUser;//创建人

    private Date createTime;//创建时间

    private String modifyUser;//修改人

    private Date modifyTime;//修改时间

    private String assetSize;//素材尺寸

    private  Short aim;

    /**
     * 广告位场景定向(逗号分开)：1.互动广告 2.自渲染 4.开屏 5.信息流大图
     */
    private String positionSceneConfig;

    /**
     * 流量控制备用配置
     */
    private String trafficControlBakConfig;

    /**
     * 素材选择类型 0.算法优选 1.手动配置
     */
    private Short assetsSelectType;

    /**
     * 权益奖励ID
     */
    private Long rightsId;

    /**
     * 域名组ID
     */
    private String kylinGroupId;

    /**
     * 效果监控转化目标（OCPA必传）
     */
    private Short targetConvType;

    /**
     *  rtb对应的开发者
     */
    private String rtbAppKey;

    /**
     * 广告&活动标签 用于直投集合页活动
     */
    private Integer ticketActivityMatchTag;

    /**
     * 是否去重有效点击 0.是 1.否
     */
    private Byte deduplicateValidClick;


    /**
     * 算法优化目标（1单目标优化 2 双目标优化）
     */
    private Short algoTarget;

    public Short getAlgoTarget() {
        return algoTarget;
    }

    public void setAlgoTarget(Short algoTarget) {
        this.algoTarget = algoTarget;
    }


    public Byte getDeduplicateValidClick() {
        return deduplicateValidClick;
    }

    public void setDeduplicateValidClick(Byte deduplicateValidClick) {
        this.deduplicateValidClick = deduplicateValidClick;
    }

    public Integer getTicketActivityMatchTag() {
        return ticketActivityMatchTag;
    }

    public void setTicketActivityMatchTag(Integer ticketActivityMatchTag) {
        this.ticketActivityMatchTag = ticketActivityMatchTag;
    }

    public Short getTargetConvType() {
        return targetConvType;
    }

    public void setTargetConvType(Short targetConvType) {
        this.targetConvType = targetConvType;
    }

    public String getRtbAppKey() {
        return rtbAppKey;
    }

    public void setRtbAppKey(String rtbAppKey) {
        this.rtbAppKey = rtbAppKey;
    }

    public String getKylinGroupId() {
        return kylinGroupId;
    }

    public void setKylinGroupId(String kylinGroupId) {
        this.kylinGroupId = kylinGroupId;
    }

    public Short getAim() {
        return aim;
    }

    public void setAim(Short aim) {
        this.aim = aim;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getAssetSize() {
        return assetSize;
    }

    public void setAssetSize(String assetSize) {
        this.assetSize = assetSize;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Long getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(Long advertiser) {
        this.advertiser = advertiser;
    }

    public Short getSettleType() {
        return settleType;
    }

    public void setSettleType(Short settleType) {
        this.settleType = settleType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Long getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Long budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public Integer getConsumeModal() {
        return consumeModal;
    }

    public void setConsumeModal(Integer consumeModal) {
        this.consumeModal = consumeModal;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url == null ? null : url.trim();
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Short getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Short isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public String getApps() {
        return apps;
    }

    public void setApps(String apps) {
        this.apps = apps;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getFlowPackageOfferConfId() {
        return flowPackageOfferConfId;
    }

    public void setFlowPackageOfferConfId(Long flowPackageOfferConfId) {
        this.flowPackageOfferConfId = flowPackageOfferConfId;
    }

    public short getIsEffectMonitor() {
        return isEffectMonitor;
    }

    public void setIsEffectMonitor(short isEffectMonitor) {
        this.isEffectMonitor = isEffectMonitor;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public short getLastStatus() {
        return lastStatus;
    }

    public void setLastStatus(short lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public String getUrlTestResult() {
        return urlTestResult;
    }

    public void setUrlTestResult(String urlTestResult) {
        this.urlTestResult = urlTestResult;
    }

    public String getPositionSceneConfig() {
        return positionSceneConfig;
    }

    public void setPositionSceneConfig(String positionSceneConfig) {
        this.positionSceneConfig = positionSceneConfig;
    }

    public Short getAssetsSelectType() {
        return assetsSelectType;
    }

    public void setAssetsSelectType(Short assetsSelectType) {
        this.assetsSelectType = assetsSelectType;
    }

    public String getTrafficControlBakConfig() {
        return trafficControlBakConfig;
    }

    public void setTrafficControlBakConfig(String trafficControlBakConfig) {
        this.trafficControlBakConfig = trafficControlBakConfig;
    }

    public Long getRightsId() {
        return rightsId;
    }

    public void setRightsId(Long rightsId) {
        this.rightsId = rightsId;
    }

    public enum AdTicketType {
        /**
         * 广告券类型。1- 常规券、2- 备用券、3- 激励券、4- 券码类、5- ADX直投、6- ADX互动、7- 激励视频、8- 激励视频备用券
         */
        TYPE_NORMALS(AdTicket.TYPE_NORMALS,"常规券"),
        TYPE_STANDBYS(AdTicket.TYPE_STANDBYS,"备用券"),
        TYPE_ENCOURAGE(AdTicket.TYPE_ENCOURAGE,"激励券"),
        TYPE_COUPON(AdTicket.TYPE_COUPON,"券码类"),
        TYPE_ADX_DIRECT(AdTicket.TYPE_ADX_DIRECT,"ADX直投"),
        TYPE_ADX_INTERACT(AdTicket.TYPE_ADX_INTERACT,"ADX互动"),
        TYPE_INSPIRE_VIDEO(AdTicket.TYPE_INSPIRE_VIDEO,"激励视频"),
        TYPE_INSPIRE_VIDEO_STANDBYS(AdTicket.TYPE_INSPIRE_VIDEO_STANDBYS,"激励视频备用券"),
        TYPE_DSP(AdTicket.TYPE_DSP,"三方DSP"),
        TYPE_RTA(AdTicket.TYPE_RTA,"RTA"),
        TYPE_PUSH(AdTicket.TYPE_PUSH,"推送券"),
        TYPE_ACTIVITY(AdTicket.TYPE_ACTIVITY,"活动券"),
        TYPE_DIRECT(AdTicket.TYPE_DIRECT,"直投券"),
        ;

        private short type;
        private String name;

        AdTicketType(short type,String name){
            this.type = type;
            this.name = name;
        }

        public short getType() {
            return type;
        }

        public String getName() {
            return name;
        }

        public static String getName(short type){
            AdTicketType[] arr = AdTicketType.values();
            for (AdTicketType c : arr) {
                if(type == c.type){
                    return c.name;
                }
            }
            return "-";
        }

        public static AdTicketType getByType(Short type) {
            if (null == type) {
                return null;
            }
            AdTicketType[] arr = AdTicketType.values();
            for (AdTicketType c : arr) {
                if (c.type == type) {
                    return c;
                }
            }
            return null;
        }

        //这个是旧的ADX广告券
        public static boolean isAdx(Short type) {
            if (null == type) {
                return false;
            }
            if (type == TYPE_ADX_DIRECT.type || type == TYPE_ADX_INTERACT.type) {
                return true;
            }
            return false;
        }

        //这个是新的ADX广告券（百度-盘古使用的）
        public static boolean isNewAdx(Short type) {
            if (null == type) {
                return false;
            }
            if (type == TYPE_ACTIVITY.type || type == TYPE_DIRECT.type) {
                return true;
            }
            return false;
        }

        public static boolean isNotAdx(Short type) {
            if (null == type) {
                return false;
            }
            return !isAdx(type);
        }

        public static boolean isNotNewAdx(Short type) {
            if (null == type) {
                return false;
            }
            return !isNewAdx(type);
        }
    }

    public enum AdTicketStatus {
        STATUS_OPEN (AdTicket.STATUS_OPEN,"开启"),
        STATUS_PAUSE   (AdTicket.STATUS_PAUSE,"暂停"),
        STATUS_CLOSE   (AdTicket.STATUS_CLOSE,"停止"),
        STATUS_DELETED  (AdTicket.STATUS_DELETED,"删除");

        private short status;
        private String name;
        AdTicketStatus(short status,String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(short status){
            for (AdTicketStatus status1:AdTicketStatus.values()){
                if(status==status1.status){
                    return status1.name;
                }
            }
            return "-";
        }
    }

    public enum AdTicketPAUSE{

        /***
         * 暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束;5-分时段预算不足;99-其它原因
         */
        PAUSE_EXCESS_BUDGET (AdTicket.PAUSE_EXCESS_BUDGET,"超出预算"),
        PAUSE_NO_BALANCE   (AdTicket.PAUSE_NO_BALANCE,"余额不足"),
        PAUSE_DATE_START   (AdTicket.PAUSE_DATE_START,"未到投放日期"),
        PAUSE_DATE_END  (AdTicket.PAUSE_DATE_END,"投放结束"),
        PAUSE_EXCESS_HOUR_BUDGET   (AdTicket.PAUSE_EXCESS_HOUR_BUDGET,"分时段预算不足"),
        PAUSE_OTHER  (AdTicket.PAUSE_OTHER,"其它原因");

        private int status;
        private String name;

        AdTicketPAUSE(int status,String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(int status){
            for (AdTicketPAUSE status1: AdTicketPAUSE.values()){
                if(status == status1.status){
                    return status1.name;
                }
            }
            return "-";
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
