package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;

public class AdTicketAdx implements Serializable {

    private static final long serialVersionUID = 6872832364266522770L;

    private Long id;

    /**
     * 券ID
     */
    private Long adTicketId;

    /**
     * 每日最多曝光次数
     */
    private Integer showMaximum;

    /**
     * 每日最多点击次数
     */
    private Integer clickMaximum;

    /**
     * 投放速度：1- 加速投放、2- 匀速投放
     */
    private Short speed;

    /**
     * 人群来源：0- 内部标签
     */
    private Short crowdSource;

    /**
     * 结算方式：1- CPC、2- CPA、4- CPM
     */
    private Short adxSettleType;

    /**
     * 单价。单位：厘
     */
    private Integer adxPrice;

    /**
     * 日限额（预算），0 表示无限额。单位：厘
     */
    private Integer adxBudgetDaily;

    /**
     * adx专员
     */
    private String adxAe;

    /**
     * 投放类型：1，App下载；2，H5；3，deeplink
     */
    private Short adxPutinType;

    /**
     * 下载类型：默认为安卓，1，安卓；2，IOS
     */
    private Short adxDownloadType;

    /**
     * 下载安装包的AppID/包名
     */
    private String adxPackageName;

    /**
     * deeplink地址
     */
    private String deeplinkUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdTicketId() {
        return adTicketId;
    }

    public void setAdTicketId(Long adTicketId) {
        this.adTicketId = adTicketId;
    }

    public Integer getShowMaximum() {
        return showMaximum;
    }

    public void setShowMaximum(Integer showMaximum) {
        this.showMaximum = showMaximum;
    }

    public Integer getClickMaximum() {
        return clickMaximum;
    }

    public void setClickMaximum(Integer clickMaximum) {
        this.clickMaximum = clickMaximum;
    }

    public Short getSpeed() {
        return speed;
    }

    public void setSpeed(Short speed) {
        this.speed = speed;
    }

    public Short getCrowdSource() {
        return crowdSource;
    }

    public void setCrowdSource(Short crowdSource) {
        this.crowdSource = crowdSource;
    }

    public Short getAdxSettleType() {
        return adxSettleType;
    }

    public void setAdxSettleType(Short adxSettleType) {
        this.adxSettleType = adxSettleType;
    }

    public Integer getAdxPrice() {
        return adxPrice;
    }

    public void setAdxPrice(Integer adxPrice) {
        this.adxPrice = adxPrice;
    }

    public Integer getAdxBudgetDaily() {
        return adxBudgetDaily;
    }

    public void setAdxBudgetDaily(Integer adxBudgetDaily) {
        this.adxBudgetDaily = adxBudgetDaily;
    }

    public String getAdxAe() {
        return adxAe;
    }

    public void setAdxAe(String adxAe) {
        this.adxAe = adxAe == null ? null : adxAe.trim();
    }

    public Short getAdxPutinType() {
        return adxPutinType;
    }

    public void setAdxPutinType(Short adxPutinType) {
        this.adxPutinType = adxPutinType;
    }

    public Short getAdxDownloadType() {
        return adxDownloadType;
    }

    public void setAdxDownloadType(Short adxDownloadType) {
        this.adxDownloadType = adxDownloadType;
    }

    public String getAdxPackageName() {
        return adxPackageName;
    }

    public void setAdxPackageName(String adxPackageName) {
        this.adxPackageName = adxPackageName == null ? null : adxPackageName.trim();
    }

    public String getDeeplinkUrl() {
        return deeplinkUrl;
    }

    public void setDeeplinkUrl(String deeplinkUrl) {
        this.deeplinkUrl = deeplinkUrl;
    }
}