package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

import cn.afterturn.easypoi.excel.annotation.Excel;

public class AdTicketCouponsCode implements Serializable {

    private static final long serialVersionUID = 2656911409393857623L;

    /**
     * 状态：0未使用，1待使用，2已使用
     */
    public static final short STATUS_UNUSED = 0;
    public static final short STATUS_RECEIVED = 1;
    public static final short STATUS_USED = 2;

    private Long id;

    private Long ticketId;

    private Short status;

    @Excel(name = "状态")
    private String statusName;

    @Excel(name = "首次展示时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date firstShowTime;

    @Excel(name = "使用时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date useTime;

    @Excel(name = "使用渠道")
    private String usePositionId;

    @Excel(name = "绑定设备号")
    private String bindDeviceNo;

    @Excel(name = "券码")
    private String couponsCode;

    @Excel(name = "添加时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    private Date modifyTime;

    private String createUser;

    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Date getFirstShowTime() {
        return firstShowTime;
    }

    public void setFirstShowTime(Date firstShowTime) {
        this.firstShowTime = firstShowTime;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getUsePositionId() {
        return usePositionId;
    }

    public void setUsePositionId(String usePositionId) {
        this.usePositionId = usePositionId == null ? null : usePositionId.trim();
    }

    public String getBindDeviceNo() {
        return bindDeviceNo;
    }

    public void setBindDeviceNo(String bindDeviceNo) {
        this.bindDeviceNo = bindDeviceNo == null ? null : bindDeviceNo.trim();
    }

    public String getCouponsCode() {
        return couponsCode;
    }

    public void setCouponsCode(String couponsCode) {
        this.couponsCode = couponsCode == null ? null : couponsCode.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public enum AdCouponsStatus {
        /**
         * 状态：0未使用，1待使用，2已使用
         */
        STATUS_UNUSED(AdTicketCouponsCode.STATUS_UNUSED,"未使用"),
        STATUS_RECEIVED(AdTicketCouponsCode.STATUS_RECEIVED,"待使用"),
        STATUS_USED(AdTicketCouponsCode.STATUS_USED,"已使用");

        private short status;
        private String name;
        AdCouponsStatus(short status, String name){
            this.status = status;
            this.name = name;
        }

        public static String getName(short status){
            for (AdCouponsStatus status1: AdCouponsStatus.values()){
                if(status == status1.status){
                    return status1.name;
                }
            }
            return "-";
        }

        public short getStatus() {
            return status;
        }

        public String getName() {
            return name;
        }
    }

    public String getStatusName() {
        return AdCouponsStatus.getName(getStatus());
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}