package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.util.Date;

public class AdTicketCouponsInfo implements Serializable {

    private static final long serialVersionUID = 2656911409393857623L;

    /**
     * 票券使用类型，0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    public static final short USETYPE_SINGLE = 0;
    public static final short USETYPE_MULTIPLE = 1;
    public static final short USETYPE_LIMITED_TIME = 2;
    public static final short USETYPE_LIMITED_NUM = 3;

    private Long id;

    private Long ticketId;

    private Short useType;

    private String code;

    private Date codeStartTime;

    private Date codeEndTime;

    private Integer codeLimitNum;

    private String content;

    private String intro;

    private String packageName;

    private Date createTime;

    private Date modifyTime;

    private String createUser;

    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getUseType() {
        return useType;
    }

    public void setUseType(Short useType) {
        this.useType = useType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public Date getCodeStartTime() {
        return codeStartTime;
    }

    public void setCodeStartTime(Date codeStartTime) {
        this.codeStartTime = codeStartTime;
    }

    public Date getCodeEndTime() {
        return codeEndTime;
    }

    public void setCodeEndTime(Date codeEndTime) {
        this.codeEndTime = codeEndTime;
    }

    public Integer getCodeLimitNum() {
        return codeLimitNum;
    }

    public void setCodeLimitNum(Integer codeLimitNum) {
        this.codeLimitNum = codeLimitNum;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro == null ? null : intro.trim();
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName == null ? null : packageName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public enum AdCouponsUseType {
        /**
         * 票券使用类型，0单次唯一码，1多次唯一码，2限时码，3限量码
         */
        USETYPE_SINGLE(AdTicketCouponsInfo.USETYPE_SINGLE,"单次唯一码"),
        USETYPE_MULTIPLE(AdTicketCouponsInfo.USETYPE_MULTIPLE,"多次唯一码"),
        USETYPE_LIMITED_TIME(AdTicketCouponsInfo.USETYPE_LIMITED_TIME,"限时码"),
        USETYPE_LIMITED_NUM(AdTicketCouponsInfo.USETYPE_LIMITED_NUM,"限量码");

        private short type;
        private String name;
        AdCouponsUseType(short type, String name){
            this.type = type;
            this.name = name;
        }

        public static String getName(short type){
            for (AdCouponsUseType type1: AdCouponsUseType.values()){
                if(type == type1.type){
                    return type1.name;
                }
            }
            return "-";
        }

        public short getType() {
            return type;
        }

        public String getName() {
            return name;
        }

        public static AdCouponsUseType getByType(Short type) {
            if (null == type) {
                return null;
            }
            AdCouponsUseType[] arr = AdCouponsUseType.values();
            for (AdCouponsUseType c : arr) {
                if (c.getType() == type) {
                    return c;
                }
            }
            return null;
        }
    }
}