package com.bxm.adsmanager.model.dao.adkeeper;

import java.io.Serializable;
import java.math.BigDecimal;

public class DownloadLandingPage implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 系统类型：1-安卓，2-IOS
     */
    private Byte osType;

    /**
     * 下载安装包的IOS Id/包名
     */
    private String appPackageName;

    /**
     * 应用介绍
     */
    private String appDesc;

    /**
     * 应用大小
     */
    private BigDecimal appSize;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 版本号
     */
    private String version;

    /**
     * 隐私协议URL
     */
    private String privacyAgreementUrl;

    /**
     * 用户权限URL
     */
    private String userRightsUrl;

    /**
     * 试玩时长
     */
    private Integer trialTime;

    /**
     * 下载完成是否自动拉起：0否，1是
     */
    private Byte downloadDoneAutoPullUp;

    /**
     * deeplink地址
     */
    private String deeplinkUrl;

    /**
     * 应用Icon
     */
    private String appIconUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl == null ? null : downloadUrl.trim();
    }

    public Byte getOsType() {
        return osType;
    }

    public void setOsType(Byte osType) {
        this.osType = osType;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    public String getAppPackageName() {
        return appPackageName;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName == null ? null : appPackageName.trim();
    }

    public String getAppDesc() {
        return appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc == null ? null : appDesc.trim();
    }

    public BigDecimal getAppSize() {
        return appSize;
    }

    public void setAppSize(BigDecimal appSize) {
        this.appSize = appSize;
    }

    public String getDeveloperName() {
        return developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName == null ? null : developerName.trim();
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    public String getPrivacyAgreementUrl() {
        return privacyAgreementUrl;
    }

    public void setPrivacyAgreementUrl(String privacyAgreementUrl) {
        this.privacyAgreementUrl = privacyAgreementUrl == null ? null : privacyAgreementUrl.trim();
    }

    public String getUserRightsUrl() {
        return userRightsUrl;
    }

    public void setUserRightsUrl(String userRightsUrl) {
        this.userRightsUrl = userRightsUrl == null ? null : userRightsUrl.trim();
    }

    public Integer getTrialTime() {
        return trialTime;
    }

    public void setTrialTime(Integer trialTime) {
        this.trialTime = trialTime;
    }

    public String getDeeplinkUrl() {
        return deeplinkUrl;
    }

    public void setDeeplinkUrl(String deeplinkUrl) {
        this.deeplinkUrl = deeplinkUrl == null ? null : deeplinkUrl.trim();
    }

    public Byte getDownloadDoneAutoPullUp() {
        return downloadDoneAutoPullUp;
    }

    public void setDownloadDoneAutoPullUp(Byte downloadDoneAutoPullUp) {
        this.downloadDoneAutoPullUp = downloadDoneAutoPullUp;
    }

    public String getAppIconUrl() {
        return appIconUrl;
    }

    public void setAppIconUrl(String appIconUrl) {
        this.appIconUrl = appIconUrl == null ? null : appIconUrl.trim();
    }
}