package com.bxm.adsmanager.model.dao.advertiser;

import java.io.Serializable;
import java.util.Date;

public class TblAdQualify implements Serializable {

    private static final long serialVersionUID = 7979329664658051379L;

    // 审核通过
    public static final int STATUS_AUDIT_PASS = 1;

    // 待审核
    public static final int STATUS_AUDIT_WAIT = 2;
    // 审核拒绝
    public static final int STATUS_AUDIT_REFUSE = 3;


    /**
     * 主键ID
     */
    private Integer id;

    /**
     * 广告主ID
     */
    private Long advertiserId;//广告主ID

    /**
     * 广告行业类别
     */
    private Integer advertiserType;

    /**
     * 资质名称
     */
    private Integer qualifyName;//资质名称

    /**
     * 审核状态 1-通过 2-待审核  3-审核拒绝
     */
    private Integer auditStatus;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 图片地址
     */
    private String image;

    /**
     * 新增时间、修改时间
     */
    private Date updateTime;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 备注
     */
    private String remark;

    /**
     * 产品名称（原推广内容）
     */
    private String content;

    /**
     * 审核拒绝备注
     */
    private String refuseRemark;

    /**
     *
     * 分类细化后需要对资质图片分类
     *
     * 资质内容  json数据
     */
    private String qualifyContent;

    /**
     * 资质过期状态
     *
     * 0：默认  兼容老数据
     * 1：已过期
     * 2：未过期
     * 3：即将过期   资质到期前三天
     */
    private Integer expireStatus;

    public Integer getExpireStatus() {
        return expireStatus;
    }

    public void setExpireStatus(Integer expireStatus) {
        this.expireStatus = expireStatus;
    }

    public String getQualifyContent() {
        return qualifyContent;
    }

    public void setQualifyContent(String qualifyContent) {
        this.qualifyContent = qualifyContent;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public Integer getAdvertiserType() {
        return advertiserType;
    }

    public void setAdvertiserType(Integer advertiserType) {
        this.advertiserType = advertiserType;
    }

    public Integer getQualifyName() {
        return qualifyName;
    }

    public void setQualifyName(Integer qualifyName) {
        this.qualifyName = qualifyName;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image == null ? null : image.trim();
    }

    public Date getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRefuseRemark() {
        return refuseRemark;
    }

    public void setRefuseRemark(String refuseRemark) {
        this.refuseRemark = refuseRemark;
    }
}