package com.bxm.adsmanager.model.dao.advertiser;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * Created by Mybatis Generator 2018/12/18
 */
@Data
public class TblStationUserWeight {
    /**
     * 权重计划ID
     */
    private Long id;

    /**
     * 广告主ID
     */
    private Long advertiserId;

    /**
     * 销售
     */
    private String sale;

    /**
     * 提权广告分类标签
     */
    private Integer ticketTagCode;

    /**
     * 提取广告数量
     */
    private Integer ticketCount;

    /**
     * 是否限制流量包？ 1Y 0N
     */
    private Boolean limitFlowPackageFlag;

    /**
     * 流量包ID,  以逗号分隔的流量包ID字符串
     */
    private String flowPackageIdsStr;

    /**
     * 流量包数量
     */
    private Integer flowPackageCount;

    /**
     * 权重系数
     */
    private Double weightCoefficient;

    /**
     * 计划提权后券消耗额度
     */
    private BigDecimal weightPlanConsume;

    /**
     * 1：已完成；0：进行中
     */
    private Byte status;

    /**
     * 消耗完成时间
     */
    private Date completeTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 修改人
     */
    private String modifier;
}