package com.bxm.adsmanager.model.dao.agencychannel;

import java.io.Serializable;

/**
 * 代理渠道.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
public class AgencyChannel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 上游代理名称
     */
    private String agencyName;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 渠道号
     */
    private String channelNo;

    /**
     * 链接类型
     */
    private String linkType;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 所属业务线
     */
    private String ownedBusiness;

    /**
     * 券ID
     */
    private Long ticketId;

    /**
     * 归属者
     */
    private String belonger;

    /**
     * 销售
     */
    private String sale;

    /**
     * 外放代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 唯一键MD5值
     */
    private String ukMd5;

    /**
     * rtb回传策略配置
     */
    private String ocpxRtbConfig;

    /**
     * 下游代理code
     */
    private String nextProxyCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName == null ? null : agencyName.trim();
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName == null ? null : productName.trim();
    }

    public String getChannelNo() {
        return channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo == null ? null : channelNo.trim();
    }

    public String getLinkType() {
        return linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType == null ? null : linkType.trim();
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl == null ? null : linkUrl.trim();
    }

    public String getOwnedBusiness() {
        return ownedBusiness;
    }

    public void setOwnedBusiness(String ownedBusiness) {
        this.ownedBusiness = ownedBusiness == null ? null : ownedBusiness.trim();
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getBelonger() {
        return belonger;
    }

    public void setBelonger(String belonger) {
        this.belonger = belonger == null ? null : belonger.trim();
    }

    public String getSale() {
        return sale;
    }

    public void setSale(String sale) {
        this.sale = sale == null ? null : sale.trim();
    }

    public String getProxyCode() {
        return proxyCode;
    }

    public void setProxyCode(String proxyCode) {
        this.proxyCode = proxyCode;
    }

    public String getUkMd5() {
        return ukMd5;
    }

    public void setUkMd5(String ukMd5) {
        this.ukMd5 = ukMd5;
    }

    public String getOcpxRtbConfig() {
        return ocpxRtbConfig;
    }

    public void setOcpxRtbConfig(String ocpxRtbConfig) {
        this.ocpxRtbConfig = ocpxRtbConfig;
    }

    public String getNextProxyCode() {
        return nextProxyCode;
    }

    public void setNextProxyCode(String nextProxyCode) {
        this.nextProxyCode = nextProxyCode;
    }
}