package com.bxm.adsmanager.model.dao.agencychannel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
public class AgencyChannelData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 日期
     */
    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    private Date thedate;

    /**
     * 代理名称
     */
    private String agencyName;

    /**
     * 渠道号
     */
    private String channelNo;

    /**
     * 收入
     */
    private BigDecimal income;

    /**
     * 有效点击单价
     */
    private BigDecimal validClickPrice;

    /**
     * 有效点击
     */
    private Long validClick;

    /**
     * 质量系数
     */
    private BigDecimal qualityFactor;

    /**
     * CPS佣金
     */
    private BigDecimal cpsBrokerage;

    /**
     * 成本
     */
    private BigDecimal cost;

    /**
     * 核减风险：0无，1有
     */
    private Byte riskReduction;

    /**
     * 质量分1
     */
    private BigDecimal qualityScoreOne;

    /**
     * 质量分2
     */
    private BigDecimal qualityScoreTwo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 归属者
     */
    private String belonger;

    /**
     * 数据校验异常：0正常，1异常
     */
    private Byte dataVerifyError;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 质量分3
     */
    private BigDecimal qualityScoreThree;

    /**
     * 质量分4
     */
    private BigDecimal qualityScoreFour;

    /**
     * 所属业务线 1.rtb 2.sdk 3.dsp 4.联盟开户 5.外放代理
     */
    private String ownedBusiness;

    /**
     * 外放代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 下游代理人code，系统字典-代理下游子类字典code
     */
    private String nextProxyCode;



    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getThedate() {
        return thedate;
    }

    public void setThedate(Date thedate) {
        this.thedate = thedate;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName == null ? null : agencyName.trim();
    }

    public String getChannelNo() {
        return channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo == null ? null : channelNo.trim();
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public BigDecimal getValidClickPrice() {
        return validClickPrice;
    }

    public void setValidClickPrice(BigDecimal validClickPrice) {
        this.validClickPrice = validClickPrice;
    }

    public Long getValidClick() {
        return validClick;
    }

    public void setValidClick(Long validClick) {
        this.validClick = validClick;
    }

    public BigDecimal getQualityFactor() {
        return qualityFactor;
    }

    public void setQualityFactor(BigDecimal qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public BigDecimal getCpsBrokerage() {
        return cpsBrokerage;
    }

    public void setCpsBrokerage(BigDecimal cpsBrokerage) {
        this.cpsBrokerage = cpsBrokerage;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public Byte getRiskReduction() {
        return riskReduction;
    }

    public void setRiskReduction(Byte riskReduction) {
        this.riskReduction = riskReduction;
    }

    public BigDecimal getQualityScoreOne() {
        return qualityScoreOne;
    }

    public void setQualityScoreOne(BigDecimal qualityScoreOne) {
        this.qualityScoreOne = qualityScoreOne;
    }

    public BigDecimal getQualityScoreTwo() {
        return qualityScoreTwo;
    }

    public void setQualityScoreTwo(BigDecimal qualityScoreTwo) {
        this.qualityScoreTwo = qualityScoreTwo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBelonger() {
        return belonger;
    }

    public void setBelonger(String belonger) {
        this.belonger = belonger == null ? null : belonger.trim();
    }

    public Byte getDataVerifyError() {
        return dataVerifyError;
    }

    public void setDataVerifyError(Byte dataVerifyError) {
        this.dataVerifyError = dataVerifyError;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public BigDecimal getQualityScoreThree() {
        return qualityScoreThree;
    }

    public void setQualityScoreThree(BigDecimal qualityScoreThree) {
        this.qualityScoreThree = qualityScoreThree;
    }

    public BigDecimal getQualityScoreFour() {
        return qualityScoreFour;
    }

    public void setQualityScoreFour(BigDecimal qualityScoreFour) {
        this.qualityScoreFour = qualityScoreFour;
    }

    public String getOwnedBusiness() {
        return ownedBusiness;
    }

    public void setOwnedBusiness(String ownedBusiness) {
        this.ownedBusiness = ownedBusiness;
    }

    public String getProxyCode() {
        return proxyCode;
    }

    public void setProxyCode(String proxyCode) {
        this.proxyCode = proxyCode;
    }

    public String getNextProxyCode() {
        return nextProxyCode;
    }

    public void setNextProxyCode(String nextProxyCode) {
        this.nextProxyCode = nextProxyCode;
    }
}