package com.bxm.adsmanager.model.dao.agencychannel;

import java.math.BigDecimal;
import java.util.Date;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
public class ProxyChannelData {

    /**
     * id
     */
    private Long id;

    /**
     * 日期
     */
    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    private Date thedate;

    /**
     * 代理名称
     */
    private String agencyName;

    /**
     * 渠道号
     */
    private String channelNo;

    /**
     * 下游
     */
    private String ds;

    /**
     * 下游单价
     */
    private BigDecimal dsPrice;

    /**
     * 下游CPS佣金
     */
    private BigDecimal dsCpsBrokerage;

    /**
     * 下游收入
     */
    private BigDecimal dsIncome;

    /**
     * 下游有效点击数
     */
    private Long dsValidClick;

    /**
     * 外放代理人
     */
    private String proxyCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getThedate() {
        return thedate;
    }

    public void setThedate(Date thedate) {
        this.thedate = thedate;
    }

    public String getAgencyName() {
        return agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName == null ? null : agencyName.trim();
    }

    public String getChannelNo() {
        return channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo == null ? null : channelNo.trim();
    }

    public String getDs() {
        return ds;
    }

    public void setDs(String ds) {
        this.ds = ds == null ? null : ds.trim();
    }

    public BigDecimal getDsPrice() {
        return dsPrice;
    }

    public void setDsPrice(BigDecimal dsPrice) {
        this.dsPrice = dsPrice;
    }

    public BigDecimal getDsCpsBrokerage() {
        return dsCpsBrokerage;
    }

    public void setDsCpsBrokerage(BigDecimal dsCpsBrokerage) {
        this.dsCpsBrokerage = dsCpsBrokerage;
    }

    public BigDecimal getDsIncome() {
        return dsIncome;
    }

    public void setDsIncome(BigDecimal dsIncome) {
        this.dsIncome = dsIncome;
    }

    public Long getDsValidClick() {
        return dsValidClick;
    }

    public void setDsValidClick(Long dsValidClick) {
        this.dsValidClick = dsValidClick;
    }

    public String getProxyCode() {
        return proxyCode;
    }

    public void setProxyCode(String proxyCode) {
        this.proxyCode = proxyCode;
    }
}