package com.bxm.adsmanager.model.dao.audit;

import java.io.Serializable;
import java.util.Date;

/**
 * tbl_ad_audit_record
 * @author 
 */
public class AdAuditRecord implements Serializable {

    public final static Short AUDITTYPE_TICKET = 1;

    public final static Short AUDITTYPE_ASSETS = 2;


    public final static Short AUDITSTAUS_PASS = 1;

    public final static Short AUDITSTAUS_REFUSE = 2;


    private Long id;

    /**
     * 券id
     */
    private Long ticketId;

    /**
     * 素材id
     */
    private Long assetsId;

    /**
     * 广告券类型。
     * @see com.bxm.adsmanager.model.dao.adkeeper.AdTicket.AdTicketType
     */
    private Short ticketType;


    /**
     * 券名称
     */
    private String ticketName;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 提交时间
     */
    private Date submitTime;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 券审核状态（1通过   2 拒绝 ）
     */
    private Short ticketAuditStatus;

    /**
     * 素材审核状态（1通过   2 拒绝 ）
     */
    private Short assetsAuditStatus;

    /**
     * 审核类型（1.券 2.素材）
     */
    private Short auditType;

    /**
     * 审核人
     */
    private String auditUser;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Long getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(Long assetsId) {
        this.assetsId = assetsId;
    }

    public Short getTicketType() {
        return ticketType;
    }

    public void setTicketType(Short ticketType) {
        this.ticketType = ticketType;
    }

    public String getAssetsName() {
        return assetsName;
    }

    public void setAssetsName(String assetsName) {
        this.assetsName = assetsName;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Short getTicketAuditStatus() {
        return ticketAuditStatus;
    }

    public void setTicketAuditStatus(Short ticketAuditStatus) {
        this.ticketAuditStatus = ticketAuditStatus;
    }

    public Short getAssetsAuditStatus() {
        return assetsAuditStatus;
    }

    public void setAssetsAuditStatus(Short assetsAuditStatus) {
        this.assetsAuditStatus = assetsAuditStatus;
    }

    public Short getAuditType() {
        return auditType;
    }

    public void setAuditType(Short auditType) {
        this.auditType = auditType;
    }

    public String getTicketName() {
        return ticketName;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    public String getAuditUser() {
        return auditUser;
    }

    public void setAuditUser(String auditUser) {
        this.auditUser = auditUser;
    }
}