package com.bxm.adsmanager.model.dao.bes;

import java.io.Serializable;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

public class BesAdvertiserInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    //ADX广告主类型：1-百度，2-美团
    public static final int ADX_ADVERTISER_TYPE_BES = 1;
    public static final int ADX_ADVERTISER_TYPE_MEITUAN = 2;

    private Integer id;

    private Integer advertiserId;

    private String advertiserName;

    private String siteName;

    private String siteUrl;

    private Integer licenceType;

    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    private Date validDate;

    private String supplementLicenseImg;

    /**
     * ADX广告主类型
     */
    private Integer adxAdvertiserType;

    /**
     * ADX方广告主ID，美团提交审核后即可获得
     */
    private String adxAdvertiserId;

    /**
     * 审核状态：0：审核通过；1：审核中；2：审核拒绝；
     */
    private Integer auditState;

    private Date createTime;

    private Date modifyTime;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Integer advertiserId) {
        this.advertiserId = advertiserId;
    }

    public String getAdvertiserName() {
        return advertiserName;
    }

    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName == null ? null : advertiserName.trim();
    }

    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName == null ? null : siteName.trim();
    }

    public String getSiteUrl() {
        return siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl == null ? null : siteUrl.trim();
    }

    public Integer getLicenceType() {
        return licenceType;
    }

    public void setLicenceType(Integer licenceType) {
        this.licenceType = licenceType;
    }

    public Date getValidDate() {
        return validDate;
    }

    public void setValidDate(Date validDate) {
        this.validDate = validDate;
    }

    public String getSupplementLicenseImg() {
        return supplementLicenseImg;
    }

    public void setSupplementLicenseImg(String supplementLicenseImg) {
        this.supplementLicenseImg = supplementLicenseImg == null ? null : supplementLicenseImg.trim();
    }

    public Integer getAdxAdvertiserType() {
        return adxAdvertiserType;
    }

    public void setAdxAdvertiserType(Integer adxAdvertiserType) {
        this.adxAdvertiserType = adxAdvertiserType;
    }

    public String getAdxAdvertiserId() {
        return adxAdvertiserId;
    }

    public void setAdxAdvertiserId(String adxAdvertiserId) {
        this.adxAdvertiserId = adxAdvertiserId == null ? null : adxAdvertiserId.trim();
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}