package com.bxm.adsmanager.model.dao.media;

import java.io.Serializable;
import java.math.BigDecimal;

import com.bxm.adsmanager.model.base.BaseModel;

/**
 * 媒体推广位
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.model.dao.media.AdMediaPosition.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-09 10:10:00
 */
public class AdMediaPosition extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6565006811290128347L;
    /**
     * 序号
     */
    private Integer number;
    /**
     * appkey
     */
    private String appkey;
    /**
     * 开发者名称
     */
    private String appname;
    /**
     * 子渠道标志
     */
    private String business;
    /**
     * 子渠道名称
     */
    private String appentrancename;
    /**
     * 标签，以逗号分隔
     */
    private String tags;

    /**
     * 广告位券id白名单，以逗号隔开
     */
    private String ticketIds;

    /**
     * 广告位挽留弹窗开启地域，以逗号分隔
     */
    private String stayWindowdsRegion;

    /**
     * 广告位挽留弹窗开启时段，以逗号分隔
     */
    private String stayWindowdsTime;

    /**
     * 媒介名称
     */
    private String mjcode;

    private String mediaType;//媒体类型
    private String positionParentClass;//投放父分类
    private String positionChildClass;//投放父分类
    private String mode;//投放方式
    private String link;//投放链接
    private String positionClassId;//投放链接id
    //合作类型（1 分成、2 采买、3 RTB）
    private String cooperationType;
    private int tagsCount;//黑名单数量

    private String positionParentClassId;//投放父分类ID
    private String positionChildClassId;//投放父分类ID
    /**
     * 可用广告数
     */
    private int tickectCount;


    // v.20180710-positionType新增
    //private String positionType; // 广告位类型
    private Integer config = 0; // 0为客服不前置,76为客服前置

    /**
     * 广告位尺寸
     */
    private String positionSize;
    /**
     * 广告位直投广告券，逗号隔开
     */
    private String directTickets;

    /**
     * 浮标素材是否前置：
     * 0不前置，1-前置
     */
    private Integer needFloatMaterial;

    private Byte newWanliu;//新增挽留（默认前置）
    private Byte more;//更多精彩（默认前置）
    private Byte rewardTicket;// 激励券是否开启
    private Byte checkUv = 0;// 是否过滤uv<100 （0 过滤 1不过滤）
    private Integer rewardTicketCount; //激励券开启数量

    private String qq;
    private Byte qqFront;
    private String kfPhone;

    private Integer openWhiteGroup  = 1; // 1是开启，其他都是关闭，默认是开启
    /**
     * 申明内容
     * 活动规则
     * 活动说明
     * 活动声明（默认不前置）
     */
    private String intro;
    private String actRule;
    private String actExplain;
    private Byte activityStatement;

    /**
     * 广告位ID(appKey-appEntranceId)
     */
    private String positionId;

    /**
     * 是否dsp
     */
    private Boolean dspFlag;

    /**
     * 广告入口场景 = 素材类型
     */
    private String entranceScene;

    /**
     * 广告位是否关闭 ？true关闭， false 开启
     */
    private Boolean closedFlag;

    /**
     * 小程序投放0:关闭，1:开启
     */
    private Boolean wechatMiniAppPutFlag;

    /**
     * 入口场景图片
     */
    private String entrancePicUrl;


    /**
     *  广告位行业0开启1关闭
     */
    private Integer doMainCodeStatus;

    /**
     * 券码投放?0:关闭，1:开启 ？true开启， false 关闭
     */
    private Boolean couponsPutinFlag;

    /**
     * 券码投放浮标位尺寸ID
     */
    private Long couponsIconSize;

    /**
     * 券码投放展示位尺寸ID
     */
    private Long couponsCreativeSize;

    /**
     * 严格屏蔽状态
     */
    private Boolean highestPositionStatus;

    /**
     * 投放方式类型：1常规投放，2券码类投放，3激励视频投放
     */
    private Byte putinType;

    /**
     * 视频方向：1横版，2竖板
     */
    private Byte videoDirection;

    /**
     * 上报地址
     */
    private String reportUrl;

    /**
     * 广告位直投券流量分配
     */
    private Integer directTicketRatio;

    /**
     * 广告位是否存在直投广告券
     */
    private Boolean haveDirectTicket;

    /**
     * ADX广告配置ID
     * 广告位ADX类型
     * @see com.bxm.adsmedia.model.enums.AppEntranceAdxAdTypeEnum
     * 广告位场景类型
     * @see com.bxm.adsmedia.model.enums.AppEntranceAdxPositionTypeEnum
     * 广告位类型的描述：多图文、单图文等
     * 正常流量占比，单位：百分比
     * 结算方式：1- CPC、2-CPA、3-OCPC、4-CPM
     * @see com.bxm.adsmedia.facade.enumdata.AppEntranceAdxPositionTypeEnum
     * ADX渠道：1-搜狗
     * ADX渠道广告位TagId
     */
    private Long appEntranceAdxId;
    private String adType;
    private Short positionType;
    private String positionTypeDesc;
    private Integer normalRequestsRatio;
    private Short settleType;
    private Short adxChannel;
    private String channelTagId;

    /**
     * 素材模版Id
     */
    private String assetsTemplateId;

    /**
     * 利润率
     */
    private Integer profitMargin;

    //ADX素材
    private AdxNative adxNative;
    private AdxPicture adxPicture;
    private AdxText adxText;
    private AdxNativeVideo adxNativeVideo;

    /**
     * 媒体是否预付类型（0非预付，1预付）
     */
    private Integer advanceTypeFlag;

    private Byte positionScene;

    /**
     * 广告位appid黑名单数量
     */
    private Long appIdBlackNum;

    /**
     * 所属国家
     */
    private String country;

    /**
     * 0：国内   1：海外
     */
    private Integer areaType;

    public static class AdxNative {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;

        /**
         * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String iconConstraints;

        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;

        public Integer getTitleMaximumLength() {
            return titleMaximumLength;
        }

        public void setTitleMaximumLength(Integer titleMaximumLength) {
            this.titleMaximumLength = titleMaximumLength;
        }

        public String getContentConstraints() {
            return contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }

        public String getIconConstraints() {
            return iconConstraints;
        }

        public void setIconConstraints(String iconConstraints) {
            this.iconConstraints = iconConstraints;
        }

        public String getPictureFormats() {
            return pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getPictureConstraints() {
            return pictureConstraints;
        }

        public void setPictureConstraints(String pictureConstraints) {
            this.pictureConstraints = pictureConstraints;
        }
    }

    public Byte getCheckUv() {
        return checkUv;
    }

    public void setCheckUv(Byte checkUv) {
        this.checkUv = checkUv;
    }

    public static class AdxPicture {
        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;

        public String getPictureFormats() {
            return pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getPictureConstraints() {
            return pictureConstraints;
        }

        public void setPictureConstraints(String pictureConstraints) {
            this.pictureConstraints = pictureConstraints;
        }
    }

    public static class AdxText {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;

        public Integer getTitleMaximumLength() {
            return titleMaximumLength;
        }

        public void setTitleMaximumLength(Integer titleMaximumLength) {
            this.titleMaximumLength = titleMaximumLength;
        }

        public String getContentConstraints() {
            return contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }
    }

    public static class AdxNativeVideo {

        /**
         * 封面图约束 {type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
         */
        private String coverPictureConstraints;

        /**
         * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String iconConstraints;

        /**
         * 大图尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
         */
        private String largeSizeConstraints;

        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 标题限制 {type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
         */
        private String titleConstraints;


        /**
         * 内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
         */
        private String contentConstraints;


        /**
         * 视频尺寸限制 {height-width-maximum_kb}，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String videoSize;

        /**
         * 播放类型 1不限 2 横屏 3 竖屏
         */
        private Byte playType;

        /**
         * 视频格式 存储配置项id 多个以逗号分割
         */
        private String videoFormats;

        public String getCoverPictureConstraints() {
            return coverPictureConstraints;
        }

        public void setCoverPictureConstraints(String coverPictureConstraints) {
            this.coverPictureConstraints = coverPictureConstraints;
        }

        public String getIconConstraints() {
            return iconConstraints;
        }

        public void setIconConstraints(String iconConstraints) {
            this.iconConstraints = iconConstraints;
        }

        public String getLargeSizeConstraints() {
            return largeSizeConstraints;
        }

        public void setLargeSizeConstraints(String largeSizeConstraints) {
            this.largeSizeConstraints = largeSizeConstraints;
        }

        public String getPictureFormats() {
            return pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getTitleConstraints() {
            return titleConstraints;
        }

        public void setTitleConstraints(String titleConstraints) {
            this.titleConstraints = titleConstraints;
        }

        public String getContentConstraints() {
            return contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }

        public String getVideoSize() {
            return videoSize;
        }

        public void setVideoSize(String videoSize) {
            this.videoSize = videoSize;
        }

        public Byte getPlayType() {
            return playType;
        }

        public void setPlayType(Byte playType) {
            this.playType = playType;
        }

        public String getVideoFormats() {
            return videoFormats;
        }

        public void setVideoFormats(String videoFormats) {
            this.videoFormats = videoFormats;
        }
    }


    public Integer getDoMainCodeStatus() {
        return doMainCodeStatus;
    }

    public void setDoMainCodeStatus(Integer doMainCodeStatus) {
        this.doMainCodeStatus = doMainCodeStatus;
    }

    public String getPositionSize() {
        return positionSize;
    }

    public void setPositionSize(String positionSize) {
        this.positionSize = positionSize;
    }

    public String getDirectTickets() {
        return directTickets;
    }

    public void setDirectTickets(String directTickets) {
        this.directTickets = directTickets;
    }
    
    public String getTicketIds() {
        return ticketIds;
    }

    public void setTicketIds(String ticketIds) {
        this.ticketIds = ticketIds;
    }

    public String getStayWindowdsRegion() {
        return stayWindowdsRegion;
    }

    public void setStayWindowdsRegion(String stayWindowdsRegion) {
        this.stayWindowdsRegion = stayWindowdsRegion;
    }

    public String getStayWindowdsTime() {
        return stayWindowdsTime;
    }

    public void setStayWindowdsTime(String stayWindowdsTime) {
        this.stayWindowdsTime = stayWindowdsTime;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }


    public int getTagsCount() {
        return tagsCount;
    }

    public void setTagsCount(int tagsCount) {
        this.tagsCount = tagsCount;
    }

    public Byte getRewardTicket() {
        return rewardTicket;
    }

    public void setRewardTicket(Byte rewardTicket) {
        this.rewardTicket = rewardTicket;
    }

    public Integer getRewardTicketCount() {
        return rewardTicketCount;
    }

    public void setRewardTicketCount(Integer rewardTicketCount) {
        this.rewardTicketCount = rewardTicketCount;
    }

    public String getAppkey() {
        return appkey;
    }

    public String getPositionClassId() {
        return positionClassId;
    }

    public void setPositionClassId(String positionClassId) {
        this.positionClassId = positionClassId;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppname() {
        return appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getAppentrancename() {
        return appentrancename;
    }

    public void setAppentrancename(String appentrancename) {
        this.appentrancename = appentrancename;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getPositionParentClass() {
        return positionParentClass;
    }

    public void setPositionParentClass(String positionParentClass) {
        this.positionParentClass = positionParentClass;
    }

    public String getPositionChildClass() {
        return positionChildClass;
    }

    public void setPositionChildClass(String positionChildClass) {
        this.positionChildClass = positionChildClass;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public int getTickectCount() {
        return tickectCount;
    }

    public void setTickectCount(int tickectCount) {
        this.tickectCount = tickectCount;
    }

    //public String getPositionType() {
    //    return positionType;
    //}
    //
    //public void setPositionType(String positionType) {
    //    this.positionType = positionType;
    //}

    public Integer getConfig() {
        return config;
    }

    public void setConfig(Integer config) {
        this.config = config;
    }

    public String getMjcode() {
        return mjcode;
    }

    public void setMjcode(String mjcode) {
        this.mjcode = mjcode;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getNeedFloatMaterial() {
        return needFloatMaterial;
    }

    public void setNeedFloatMaterial(Integer needFloatMaterial) {
        this.needFloatMaterial = needFloatMaterial;
    }

    public String getPositionParentClassId() {
        return positionParentClassId;
    }

    public void setPositionParentClassId(String positionParentClassId) {
        this.positionParentClassId = positionParentClassId;
    }

    public Integer getAreaType() {
        return areaType;
    }

    public void setAreaType(Integer areaType) {
        this.areaType = areaType;
    }

    public String getPositionChildClassId() {
        return positionChildClassId;
    }

    public void setPositionChildClassId(String positionChildClassId) {
        this.positionChildClassId = positionChildClassId;
    }

    public Byte getNewWanliu() {
        return newWanliu;
    }

    public void setNewWanliu(Byte newWanliu) {
        this.newWanliu = newWanliu;
    }

    public Byte getMore() {
        return more;
    }

    public void setMore(Byte more) {
        this.more = more;
    }

    public Byte getActivityStatement() {
        return activityStatement;
    }

    public void setActivityStatement(Byte activityStatement) {
        this.activityStatement = activityStatement;
    }

    public String getActRule() {
        return actRule;
    }

    public void setActRule(String actRule) {
        this.actRule = actRule;
    }

    public String getActExplain() {
        return actExplain;
    }

    public void setActExplain(String actExplain) {
        this.actExplain = actExplain;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Boolean getDspFlag() {
        return dspFlag;
    }

    public void setDspFlag(Boolean dspFlag) {
        this.dspFlag = dspFlag;
    }

    public String getEntranceScene() {
        return entranceScene;
    }

    public void setEntranceScene(String entranceScene) {
        this.entranceScene = entranceScene;
    }

    public Boolean getClosedFlag() {
        return closedFlag;
    }

    public void setClosedFlag(Boolean closedFlag) {
        this.closedFlag = closedFlag;
    }

    public Boolean getWechatMiniAppPutFlag() {
        return wechatMiniAppPutFlag;
    }

    public void setWechatMiniAppPutFlag(Boolean wechatMiniAppPutFlag) {
        this.wechatMiniAppPutFlag = wechatMiniAppPutFlag;
    }

    public String getEntrancePicUrl() {
        return entrancePicUrl;
    }

    public void setEntrancePicUrl(String entrancePicUrl) {
        this.entrancePicUrl = entrancePicUrl;
    }

    public String getCooperationType() {
        return cooperationType;
    }

    public void setCooperationType(String cooperationType) {
        this.cooperationType = cooperationType;
    }


    public Boolean getHighestPositionStatus() {
        return highestPositionStatus;
    }

    public void setHighestPositionStatus(Boolean highestPositionStatus) {
        this.highestPositionStatus = highestPositionStatus;
    }

    public Boolean getCouponsPutinFlag() {
        return couponsPutinFlag;
    }

    public void setCouponsPutinFlag(Boolean couponsPutinFlag) {
        this.couponsPutinFlag = couponsPutinFlag;
    }

    public Long getCouponsIconSize() {
        return couponsIconSize;
    }

    public void setCouponsIconSize(Long couponsIconSize) {
        this.couponsIconSize = couponsIconSize;
    }

    public Long getCouponsCreativeSize() {
        return couponsCreativeSize;
    }

    public void setCouponsCreativeSize(Long couponsCreativeSize) {
        this.couponsCreativeSize = couponsCreativeSize;
    }

    public Byte getPutinType() {
        return putinType;
    }

    public void setPutinType(Byte putinType) {
        this.putinType = putinType;
    }

    public Byte getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Byte videoDirection) {
        this.videoDirection = videoDirection;
    }

    public String getReportUrl() {
        return reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public Long getAppEntranceAdxId() {
        return appEntranceAdxId;
    }

    public void setAppEntranceAdxId(Long appEntranceAdxId) {
        this.appEntranceAdxId = appEntranceAdxId;
    }

    public Short getPositionType() {
        return positionType;
    }

    public void setPositionType(Short positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc;
    }

    public String getAdType() {
        return adType;
    }

    public void setAdType(String adType) {
        this.adType = adType;
    }

    public Integer getNormalRequestsRatio() {
        return normalRequestsRatio;
    }

    public void setNormalRequestsRatio(Integer normalRequestsRatio) {
        this.normalRequestsRatio = normalRequestsRatio;
    }

    public Short getSettleType() {
        return settleType;
    }

    public void setSettleType(Short settleType) {
        this.settleType = settleType;
    }

    public Short getAdxChannel() {
        return adxChannel;
    }

    public void setAdxChannel(Short adxChannel) {
        this.adxChannel = adxChannel;
    }

    public String getChannelTagId() {
        return channelTagId;
    }

    public void setChannelTagId(String channelTagId) {
        this.channelTagId = channelTagId;
    }

    public String getAssetsTemplateId() {
        return assetsTemplateId;
    }

    public void setAssetsTemplateId(String assetsTemplateId) {
        this.assetsTemplateId = assetsTemplateId;
    }

    public Integer getProfitMargin() {
        return profitMargin;
    }

    public void setProfitMargin(Integer profitMargin) {
        this.profitMargin = profitMargin;
    }

    public AdxNative getAdxNative() {
        return adxNative;
    }

    public void setAdxNative(AdxNative adxNative) {
        this.adxNative = adxNative;
    }

    public AdxPicture getAdxPicture() {
        return adxPicture;
    }

    public void setAdxPicture(AdxPicture adxPicture) {
        this.adxPicture = adxPicture;
    }

    public AdxText getAdxText() {
        return adxText;
    }

    public void setAdxText(AdxText adxText) {
        this.adxText = adxText;
    }

    public AdxNativeVideo getAdxNativeVideo() {
        return adxNativeVideo;
    }

    public void setAdxNativeVideo(AdxNativeVideo adxNativeVideo) {
        this.adxNativeVideo = adxNativeVideo;
    }

    public Integer getDirectTicketRatio() {
        return directTicketRatio;
    }

    public void setDirectTicketRatio(Integer directTicketRatio) {
        this.directTicketRatio = directTicketRatio;
    }

    public Boolean getHaveDirectTicket() {
        return haveDirectTicket;
    }

    public void setHaveDirectTicket(Boolean haveDirectTicket) {
        this.haveDirectTicket = haveDirectTicket;
    }

    public Integer getAdvanceTypeFlag() {
        return advanceTypeFlag;
    }

    public void setAdvanceTypeFlag(Integer advanceTypeFlag) {
        this.advanceTypeFlag = advanceTypeFlag;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    public Long getAppIdBlackNum() {
        return appIdBlackNum;
    }

    public void setAppIdBlackNum(Long appIdBlackNum) {
        this.appIdBlackNum = appIdBlackNum;
    }

    public String getCountry() {
        return country;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public Integer getOpenWhiteGroup() {
        return openWhiteGroup;
    }

    public void setOpenWhiteGroup(Integer openWhiteGroup) {
        this.openWhiteGroup = openWhiteGroup;
    }

    public Byte getQqFront() {
        return qqFront;
    }

    public void setQqFront(Byte qqFront) {
        this.qqFront = qqFront;
    }

    public String getKfPhone() {
        return kfPhone;
    }

    public void setKfPhone(String kfPhone) {
        this.kfPhone = kfPhone;
    }

    public void setCountry(String country) {
        this.country = country;
    }
}
