package com.bxm.adsmanager.model.dao.media;

import com.bxm.adsmanager.model.enums.CitysEnum;
import com.bxm.util.StringUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * 老系统标签
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.model.dao.media.OldTagMsg.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-10 15:39:00
 */
public class OldTagMsg {
    /**
     * 广告位 ID
     */
    private String positionId;
    /**
     * 标签
     */
    private String tag;

    /**
     * 地域
     */
    private String districts;
    /**
     * 转化成带 code 的地域
     */
    private List<String> regions;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDistricts() {
        return districts;
    }

    public void setDistricts(String districts) {
        this.districts = districts;
        if(StringUtil.isNotEmpty(districts)){
            regions=new ArrayList<>();
            for(String district:districts.split(",")){
                this.regions.add(CitysEnum.getCodeByName(district));
                //this.regions.add(district);
            }
        }

    }

    public List<String> getRegions() {
        return regions;
    }

    public void setRegions(List<String> regions) {
        this.regions = regions;
    }
}
