package com.bxm.adsmanager.model.dao.mediamanager;

import java.math.BigDecimal;
import java.util.Date;

public class AdTicketPositionWeight {
    private Long id;

    private String positionId;

    private Long ticketId;

    private BigDecimal arpu;

    private BigDecimal weight;

    private Double interventionFactor;

    private Date createTime;
    
    public AdTicketPositionWeight() {
		super();
	}

    public AdTicketPositionWeight(String positionId, Long ticketId, BigDecimal arpu, 
			Double interventionFactor) {
		super();
		this.positionId = positionId;
		this.ticketId = ticketId;
		this.arpu = arpu;
		this.weight = arpu.multiply(new BigDecimal(interventionFactor));
		this.interventionFactor = interventionFactor;
	}
    
	public AdTicketPositionWeight(String positionId, Long ticketId, Double interventionFactor) {
		super();
		this.positionId = positionId;
		this.ticketId = ticketId;
		this.interventionFactor = interventionFactor;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId == null ? null : positionId.trim();
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public BigDecimal getArpu() {
        return arpu;
    }

    public void setArpu(BigDecimal arpu) {
        this.arpu = arpu;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public Double getInterventionFactor() {
        return interventionFactor;
    }

    public void setInterventionFactor(Double interventionFactor) {
        this.interventionFactor = interventionFactor;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}