package com.bxm.adsmanager.model.dao.mediamanager;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * <h3>tbl_ad_ticket_position_weight_new</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2021/4/6 14:14
 */
@Data
public class AdTicketPositionWeightNew implements Serializable {

    public static final int STATUS_OPEN = 1;
    public static final int STATUS_DELETE = -1;

    @NotNull(message = "id不能为空", groups = { Update.class,Delete.class})
    private Long id;


    private Long ticketId;


    private String ticketName;
    /**
     * 权重值
     */
    @NotNull(message = "权重不能为空", groups = {Add.class, Update.class})
    private BigDecimal weight;

    /**
     * 广告位ID
     */
    @NotNull(message = "广告位ID不能为空", groups = {Add.class, Update.class})
    private String positionId;
    /**
     * 广告位代号
     */
    @NotNull(message = "广告位代号不能为空", groups = {Add.class})
    private String positionCode;

    /**
     * 广告位名称
     */
    @NotNull(message = "广告位名称不能为空", groups = {Add.class})
    private String positionName;

    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR19, timezone = "GMT+8")
    private Date updateTime;

    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR19, timezone = "GMT+8")
    private Date createTime;

    private String createUser;

    private String updateUser;

    /**
     * 备注
     */
    private String remark;

    /**
     * 1可用，-1删除，0关闭
     */
    private Integer status;

    /**
     * 定时关闭时间
     */
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR19)
    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR19, timezone = "GMT+8")
    private Date stopTime;

    public interface Add {
    }

    public interface Update {
    }

    public interface Delete {
    }

    private String list;

    @Data
     public static class TicketDTO implements Serializable{
        private Long ticketId;
        private String ticketName;
    }

}