package com.bxm.adsmanager.model.dao.monitor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description: 17测速url
 * @date:2018年8月7日 下午6:39:31
 */
public class CeSuUrl implements Serializable {

    private static final long serialVersionUID   = 7305328953786706367L;

    private Double            totalTime          = 0.0;                 // 总时间
    private Double            ttfBTime           = 0.0;                 // 首字节时间
    private Double            connectTime        = 0.0;                 // 连接时间
    private String            proviceCity;                              // 省市区
    private Double            downTime           = 0.0;                 // 下载时间
    private int               FileSize           = 0;                   // 文件大小
    private int               RealSize           = 0;                   // 真实大小
    private Double            downloadSpeed      = 0.0;                 // 下载速度的算法（RealSize/1024/DownTime））
    private String            createTime;                               // 创建时间

    private Double            totalTotalTime     = 0.0;                 // 合计总时间
    private Double            totalTTFBTime      = 0.0;                 // 合计首字节时间
    private Double            totalConnectTime   = 0.0;                 // 合计连接时间
    private Double            totalDownTime      = 0.0;                 // 合计下载时间
    private Double            totaldownloadSpeed = 0.0;                 // 合计下载速度

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Double getTotalTotalTime() {
        return new BigDecimal(totalTotalTime).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public void setTotalTotalTime(Double totalTotalTime) {
        this.totalTotalTime = totalTotalTime;
    }

    public Double getTotalTTFBTime() {
        return new BigDecimal(totalTTFBTime).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public void setTotalTTFBTime(Double totalTTFBTime) {
        this.totalTTFBTime = totalTTFBTime;
    }
    
    public Double getTotalConnectTime() {
        return new BigDecimal(totalConnectTime).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    
    public void setTotalConnectTime(Double totalConnectTime) {
        this.totalConnectTime = totalConnectTime;
    }

    public Double getTotalDownTime() {
        return new BigDecimal(totalDownTime).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public void setTotalDownTime(Double totalDownTime) {
        this.totalDownTime = totalDownTime;
    }

    public Double getTotaldownloadSpeed() {
        return new BigDecimal(totaldownloadSpeed).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public void setTotaldownloadSpeed(Double totaldownloadSpeed) {
        this.totaldownloadSpeed = totaldownloadSpeed;
    }

    public Double getTotalTime() {
        return totalTime;
    }

    public void setTotalTime(Double totalTime) {
        this.totalTime = totalTime;
    }
 
  
    
    
    public Double getTtfBTime() {
        return ttfBTime;
    }

    
    public void setTtfBTime(Double ttfBTime) {
        this.ttfBTime = ttfBTime;
    }

    public Double getConnectTime() {
        return connectTime;
    }

    
    public void setConnectTime(Double connectTime) {
        this.connectTime = connectTime;
    }

    public String getProviceCity() {
        return proviceCity;
    }

    public void setProviceCity(String proviceCity) {
        this.proviceCity = proviceCity;
    }
 
    
    public Double getDownTime() {
        return downTime;
    }

    
    public void setDownTime(Double downTime) {
        this.downTime = downTime;
    }

    public int getFileSize() {
        return FileSize;
    }

    public void setFileSize(int fileSize) {
        FileSize = fileSize;
    }

    public int getRealSize() {
        return RealSize;
    }

    public void setRealSize(int realSize) {
        RealSize = realSize;
    }

    public Double getDownloadSpeed() {
        return new BigDecimal(downloadSpeed).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    public void setDownloadSpeed(Double downloadSpeed) {
        this.downloadSpeed = downloadSpeed;
    }

}
