package com.bxm.adsmanager.model.dao.monitor;

import java.io.Serializable;
import java.util.Date;

/**
* @Title:WarnConfig.java
* @Package:com.bxm.adsmanager.model.dao.monitor
* @Description: 预警配置类
* @date:2018年8月7日 下午6:40:35
 */
public class WarnConfig implements Serializable {
    
    private static final long serialVersionUID = -3504019827742832800L;
    
    /**
     * 主键ID
     */
    private Long id;
    
    /**
     * 预警配置key
     */
    private String propKey;
    
    /**
     * 预警配置值
     */
    private String propValue;//
    
    /**
     * 属性描述
     */
    private String propDesc;
    
    /**
     * 创建时间
     */
    private Date createTime;
    
    /**
     * 修改时间
     */
    private Date modifyTime;
    
    /**
     * 监控时间段,近多少小时
     */
    private Integer monitorPeriod;
    
    /**
     * 备注
     */
    private String remark;
    
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPropKey() {
        return propKey;
    }

    public void setPropKey(String propKey) {
        this.propKey = propKey == null ? null : propKey.trim();
    }

    public String getPropValue() {
        return propValue;
    }

    public void setPropValue(String propValue) {
        this.propValue = propValue == null ? null : propValue.trim();
    }

    public String getPropDesc() {
        return propDesc;
    }

    public void setPropDesc(String propDesc) {
        this.propDesc = propDesc == null ? null : propDesc.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Integer getMonitorPeriod() {
        return monitorPeriod;
    }

    public void setMonitorPeriod(Integer monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}