package com.bxm.adsmanager.model.dao.overseas;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * overseas_offline_advert
 * @author 
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OverseasOfflineAdvert implements Serializable {
    private Long id;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifiedTime;

    /**
     * 推广id
     */
    private String offerId;

    /**
     * 推广来源 例如：有米、木瓜
     */
    private Integer offerSource;

    /**
     * 推广分类 使用列表[,,,]
     */
    private String offerCategory;

    /**
     * 推广状态 例如：可用、不可用
     */
    private Integer offerStatus;

    /**
     * 推广名称
     */
    private String offerName;

    /**
     * 推广描述
     */
    private String offerDesc;

    /**
     * 推广国家 使用列表[,,,]
     */
    private String offerCountry;

    /**
     * app名字
     */
    private String appName;

    /**
     * app包名
     */
    private String appPackageName;

    /**
     * app分类 使用列表[,,,]
     */
    private String appCategory;

    /**
     * app大小
     */
    private Integer appSize;

    /**
     * app评分
     */
    private String appRate;

    /**
     * app标签 使用列表[,,,]
     */
    private String appLabel;

    /**
     * app描述
     */
    private String appDesc;

    /**
     * 支付价格 统一换算为美元
     */
    private BigDecimal payPrice;

    /**
     * 结算方式 cpc cpm
     */
    private Integer payType;

    /**
     * 追踪链接
     */
    private String trackingLink;

    /**
     * 追踪链接要替换的参数 使用列表[,,,]
     */
    private String trackingLinkParameter;

    /**
     * 流量来源 使用列表[,,,]
     */
    private String trafficSource;

    /**
     * 流量网络 使用列表[,,,]
     */
    private String trafficNetwork;

    /**
     * 排除流量 使用列表[,,,]
     */
    private String trafficExclude;

    /**
     * icon素材 使用列表[,,,]
     * @see com.bxm.adsmanager.model.dao.overseas.OverseasGeneralMaterial
     */
    private String iconMaterial;

    /**
     * 图片素材 使用列表[,,,]
     * @see com.bxm.adsmanager.model.dao.overseas.OverseasGeneralMaterial
     */
    private String imageMaterial;

    /**
     * 视频素材 使用列表[,,,]
     * @see com.bxm.adsmanager.model.dao.overseas.OverseasGeneralMaterial
     */
    private String videoMaterial;

    /**
     * 目标平台 ios android 使用列表[,,,]
     */
    private String targetPlatform;

    /**
     * 目标设备 手机 平板 使用列表[,,,]
     */
    private String targetDevice;

    /**
     * 目标运营商 使用列表[,,,]
     */
    private String targetCarries;

    /**
     * 预览链接
     */
    private String previewUrl;

    /**
     * 最小版本
     */
    private String minVersion;

    /**
     * 法律文件
     */
    private String legalDoc;

    /**
     * kpi
     */
    private String kpi;

    /**
     * 转换方式 例如：下载、填写表单、双次点击 使用列表[,,,]
     */
    private String conversionFlow;

    /**
     * 日转化上限 例如：100
     */
    private Integer dailyCap;

    /**
     * 链接类型 下载 落地 dp 
     */
    private Integer linkType;

    /**
     * 黑名单 使用列表[,,,]
     */
    private String blacklist;

    /**
     * 白名单 使用列表[,,,]
     */
    private String whitelist;

    /**
     * 任务描述
     */
    private String taskDesc;

    private static final long serialVersionUID = 1L;
}