package com.bxm.adsmanager.model.dao.position;

import java.io.Serializable;
import java.util.Date;

import org.hibernate.validator.constraints.NotBlank;

import cn.afterturn.easypoi.excel.annotation.Excel;
/**
* @Title:PositionQualityFactor.java
* @Package:com.bxm.adsmanager.model.dao.position
* @Description: 广告位质量因子实体类
* @date:2018年10月15日 下午4:55:56
* @author wangchao
 */
public class PositionQualityFactor implements Serializable{
    private static final long serialVersionUID = -3193720097593340016L;
    
    /**
     * 主键ID
     */
    private Long id;
    
    /**
     * appKey
     */
    //@Excel(name = "app_key")
    //@NotBlank(message = "app_key不能为空")
    private String appKey;
    
    /**
     * business
     */
    //@Excel(name = "business")
    //@NotBlank(message = "business不能为空")
    private String business;
    /**
     * 广告位ID
     */
    private String positionId;


    /**
     * 广告位代号
     */
    @Excel(name = "广告位代号")
    @NotBlank(message = " 广告位代号不能为空")
    private String positionCode;
    
    /**
     * 质量因子
     */
    @Excel(name = "等级")
    //@NotBlank(message = "等级不能为空")
    private String factor;
    
    /**
     * 导入时间
     */
    private String importTime;
    
    /**
     * 创建时间
     */
    private Date createTime;
    
    /**
     * 修改时间
     */
    private Date modifyTime;
    
    /**
     * 创建人
     */
    private String createUser;
    
    /**
     * 修改人
     */
    private String modifyUser;
    
    /**
     * 备注
     */
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId == null ? null : positionId.trim();
    }

    public String getFactor() {
        return factor;
    }

    public void setFactor(String factor) {
        this.factor = factor == null ? null : factor.trim();
    }

    public String getImportTime() {
        return importTime;
    }

    public void setImportTime(String importTime) {
        this.importTime = importTime == null ? null : importTime.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getPositionCode() {
        return positionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }
}