package com.bxm.adsmanager.model.dao.precharge;

import javax.swing.plaf.basic.BasicTextAreaUI;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * tbl_precharge_correct_record
 * @author 
 */
public class PrechargeCorrectRecord implements Serializable {

    // 增加
    public final static Byte CORRECT_TYPE_PLUS = 1;
    // 减少
    public final static Byte CORRECT_TYPE_SUBTRACT = 2;

    public final static Byte STATUS_AUDIT_WAIT = 0;

    public final static Byte STATUS_AUDIT_PASS = 1;

    public final static Byte STATUS_AUDIT_REFUSE = 2;

    public final static Byte RECORD_TYPE_CORRECT = 1;

    public final static Byte RECORD_TYPE_MOVE = 2;


    private Long id;

    /**
     * 预付配置id
     */
    private Long accountId;

    /**
     * 预付配置名称
     */
    private String accountName;

    /**
     * 修正金额
     */
    private BigDecimal correctAmount;

    /**
     * 修正类型 1.增加 2.减少
     */
    private Byte correctType;

    /**
     * 修正前余额
     */
    private BigDecimal originBalance;

    /**
     * 预期修正后的余额
     */
    private BigDecimal expectBalance;

    /**
     * 审核后最终的余额
     */
    private BigDecimal finalBalance;

    /**
     * 昨日消耗金额
     */
    private BigDecimal yesterdayConsume;

    /**
     * 修正原因
     */
    private String correctReason;

    /**
     * 审核状态 0.待审核 1.审核通过 2.审核拒绝
     */
    private Byte auditStatus;

    /**
     * 审核拒绝原因
     */
    private String refuseReason;


    /**
     * 记录类型：1.修正数据 2.切换账户
     */
    private Byte recordType;

    /**
     * record_type 为2时迁入的账户
     */
    private Long toAccountId;

    /**
     * record_type 为2时迁入的账户名称
     */
    private String toAccountName;

    /**
     * 迁入广告位 开始日期
     */
    private String toStartDate;

    /**
     * 账户迁入的广告位id，多个用逗号分隔
     */
    private String toPositionId;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BigDecimal getCorrectAmount() {
        return correctAmount;
    }

    public void setCorrectAmount(BigDecimal correctAmount) {
        this.correctAmount = correctAmount;
    }

    public Byte getCorrectType() {
        return correctType;
    }

    public void setCorrectType(Byte correctType) {
        this.correctType = correctType;
    }

    public BigDecimal getOriginBalance() {
        return originBalance;
    }

    public void setOriginBalance(BigDecimal originBalance) {
        this.originBalance = originBalance;
    }

    public BigDecimal getExpectBalance() {
        return expectBalance;
    }

    public void setExpectBalance(BigDecimal expectBalance) {
        this.expectBalance = expectBalance;
    }

    public BigDecimal getFinalBalance() {
        return finalBalance;
    }

    public void setFinalBalance(BigDecimal finalBalance) {
        this.finalBalance = finalBalance;
    }

    public BigDecimal getYesterdayConsume() {
        return yesterdayConsume;
    }

    public void setYesterdayConsume(BigDecimal yesterdayConsume) {
        this.yesterdayConsume = yesterdayConsume;
    }

    public String getCorrectReason() {
        return correctReason;
    }

    public void setCorrectReason(String correctReason) {
        this.correctReason = correctReason;
    }

    public Byte getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Byte auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Byte getRecordType() {
        return recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }

    public Long getToAccountId() {
        return toAccountId;
    }

    public void setToAccountId(Long toAccountId) {
        this.toAccountId = toAccountId;
    }

    public String getToAccountName() {
        return toAccountName;
    }

    public void setToAccountName(String toAccountName) {
        this.toAccountName = toAccountName;
    }

    public String getToStartDate() {
        return toStartDate;
    }

    public void setToStartDate(String toStartDate) {
        this.toStartDate = toStartDate;
    }

    public String getToPositionId() {
        return toPositionId;
    }

    public void setToPositionId(String toPositionId) {
        this.toPositionId = toPositionId;
    }
}