package com.bxm.adsmanager.model.dao.precharge;

import com.bxm.adsmanager.integration.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * tbl_precharge_developer_relation
 * @author
 */
public class PrechargeDeveloperRelation implements Serializable {

    public static final String UNLIMITED_DATE = "2099-01-01";

    private Integer id;

    /**
     * 预付账户id
     */
    private Long accountId;

    /**
     * 开发者id
     */
    private Long providerId;

    /**
     * 开发者appKey
     */
    private String providerAppKey;

    /**
     * 开始统计日期
     */
    private String startDate;

    /**
     * 结束统计日期
     */
    private String endDate;

    private static final long serialVersionUID = 1L;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getProviderId() {
        return providerId;
    }

    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }

    public String getProviderAppKey() {
        return providerAppKey;
    }

    public void setProviderAppKey(String providerAppKey) {
        this.providerAppKey = providerAppKey;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * 该配置是否包含指定日期
     * @param date
     * @return
     */
    public Boolean containDate(String date) {
        if (StringUtils.isBlank(date)) {
            return false;
        }
        String endDate = StringUtils.isBlank(this.getEndDate()) ? UNLIMITED_DATE : this.getEndDate();
        return DateUtil.compareDateStr(date, this.getStartDate()) >= 0 && DateUtil.compareDateStr(date, endDate) <= 0;
    }
}