package com.bxm.adsmanager.model.dao.precharge;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * tbl_precharge_new_correct_record
 * @author
 */
public class PrechargeNewCorrectRecord implements Serializable {

    // 增加
    public final static Byte CORRECT_TYPE_PLUS = 1;
    // 减少
    public final static Byte CORRECT_TYPE_SUBTRACT = 2;

    public final static Byte STATUS_AUDIT_WAIT = 0;

    public final static Byte STATUS_AUDIT_PASS = 1;

    public final static Byte STATUS_AUDIT_REFUSE = 2;

    public final static Byte RECORD_TYPE_CORRECT = 1;

    public final static Byte RECORD_TYPE_MOVE = 2;



    private Long id;

    /**
     * 预付配置id
     */
    private Long accountId;

    /**
     * 预付配置名称
     */
    private String accountName;

    /**
     * 修正日期
     */
    private String datetime;

    /**
     * 修正金额
     */
    private BigDecimal correctAmount;

    /**
     * 修正类型 1.增加 2.减少
     */
    private Byte correctType;

    /**
     * 修正前余额
     */
    private BigDecimal originBalance;

    /**
     * 预期修正后的余额
     */
    private BigDecimal expectBalance;

    /**
     * 审核后最终的余额
     */
    private BigDecimal finalBalance;

    /**
     * 修正原因
     */
    private String correctReason;

    /**
     * 审核状态 0.待审核 1.审核通过 2.审核拒绝
     */
    private Byte auditStatus;

    /**
     * 审核拒绝原因
     */
    private String refuseReason;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public BigDecimal getCorrectAmount() {
        return correctAmount;
    }

    public void setCorrectAmount(BigDecimal correctAmount) {
        this.correctAmount = correctAmount;
    }

    public Byte getCorrectType() {
        return correctType;
    }

    public void setCorrectType(Byte correctType) {
        this.correctType = correctType;
    }

    public BigDecimal getOriginBalance() {
        return originBalance;
    }

    public void setOriginBalance(BigDecimal originBalance) {
        this.originBalance = originBalance;
    }

    public BigDecimal getExpectBalance() {
        return expectBalance;
    }

    public void setExpectBalance(BigDecimal expectBalance) {
        this.expectBalance = expectBalance;
    }

    public BigDecimal getFinalBalance() {
        return finalBalance;
    }

    public void setFinalBalance(BigDecimal finalBalance) {
        this.finalBalance = finalBalance;
    }

    public String getCorrectReason() {
        return correctReason;
    }

    public void setCorrectReason(String correctReason) {
        this.correctReason = correctReason;
    }

    public Byte getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Byte auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}