package com.bxm.adsmanager.model.dao.precharge;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * tbl_precharge_record
 * @author 
 */
public class PrechargeRecord implements Serializable {

    public final static Byte TYPE_RECHARGE = (byte) 1;

    public final static Byte TYPE_CONSUME = (byte) 2;

    public final static Byte RECORD_TYPE_NORMAL = (byte) 1;

    public final static Byte RECORD_TYPE_MOVE = (byte) 2;

    private Long id;

    /**
     * 日期
     */
    private String datetime;

    /**
     * 预付账号id
     */
    private Long accountId;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 消耗金额
     */
    private BigDecimal consumeAmount;

    /**
     * 充值金额
     */
    private BigDecimal rechargeAmount;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 流水类型（1.充值 2.消耗）
     */
    private Byte type;


    /**
     * 记录类型：1.普通 2.切换主体
     */
    private Byte recordType;

    /**
     * 迁入或迁出的账户id 具体根据是消耗还是充值来判断
     */
    private Long toAccountId;

    /**
     * 迁入或迁出的账户名称 具体根据是消耗还是充值来判断
     */
    private String toAccountName;

    private String createUser;

    private Date createTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BigDecimal getConsumeAmount() {
        return consumeAmount;
    }

    public void setConsumeAmount(BigDecimal consumeAmount) {
        this.consumeAmount = consumeAmount;
    }

    public BigDecimal getRechargeAmount() {
        return rechargeAmount;
    }

    public void setRechargeAmount(BigDecimal rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Byte getRecordType() {
        return recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }

    public Long getToAccountId() {
        return toAccountId;
    }

    public void setToAccountId(Long toAccountId) {
        this.toAccountId = toAccountId;
    }

    public String getToAccountName() {
        return toAccountName;
    }

    public void setToAccountName(String toAccountName) {
        this.toAccountName = toAccountName;
    }
}