package com.bxm.adsmanager.model.dao.rta;

import java.io.Serializable;
import java.util.Date;

/**
 * tbl_rta_config
 * @author 
 */
public class RtaConfig implements Serializable {
    /**
     * 自增id
     */
    private Integer id;

    /**
     * rta id
     */
    private String rtaId;

    /**
     * rta媒体
     */
    private String rtaMedia;

    /**
     * rta产品名称
     */
    private String rtaProduct;

    /**
     * 最高qps
     */
    private Integer qps;

    /**
     * 数据源类型 1.广告主RTA 2.内部人群包
     */
    private Byte sourceType;

    /**
     * 定向的广告主rta
     */
    private Integer rtaTarget;

    /**
     * rta定制参数
     */
    private String rtaParam;

    /**
     * 状态 0.关闭 1.开启
     */
    private Byte status;

    /**
     * 定向的人群包id 规则：白名单id&黑名单id
     */
    private String crowdPackageRule;

    private String createUser;

    private Date createTime;

    private String updateUser;

    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRtaId() {
        return rtaId;
    }

    public void setRtaId(String rtaId) {
        this.rtaId = rtaId;
    }

    public String getRtaMedia() {
        return rtaMedia;
    }

    public void setRtaMedia(String rtaMedia) {
        this.rtaMedia = rtaMedia;
    }

    public String getRtaProduct() {
        return rtaProduct;
    }

    public void setRtaProduct(String rtaProduct) {
        this.rtaProduct = rtaProduct;
    }

    public Integer getQps() {
        return qps;
    }

    public void setQps(Integer qps) {
        this.qps = qps;
    }

    public Byte getSourceType() {
        return sourceType;
    }

    public void setSourceType(Byte sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getRtaTarget() {
        return rtaTarget;
    }

    public void setRtaTarget(Integer rtaTarget) {
        this.rtaTarget = rtaTarget;
    }

    public String getRtaParam() {
        return rtaParam;
    }

    public void setRtaParam(String rtaParam) {
        this.rtaParam = rtaParam;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getCrowdPackageRule() {
        return crowdPackageRule;
    }

    public void setCrowdPackageRule(String crowdPackageRule) {
        this.crowdPackageRule = crowdPackageRule;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}