package com.bxm.adsmanager.model.dao.rtb;

import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class PositionRtb {
    private Long id;

    private String positionId;

    private Byte targetType;

    private String targetOneRtb;

    private String targetTwoRtb;

    private String  token;

    private String  customerId;

    private String sourceId;

    private String headTicketJson;

    private String helpTicketJson;

    private Integer sourceType;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    private String activityOne;

    private String activityTwo;

    /**
     * CVR 回传控制
     */
    private List<RtbCvrControl> cvrControls;

    /**
     * 扣量回传控制
     */
    private List<RtbCvrControl> rateControls;

    /**
     * 扣量回传控制
     */
    private List<RtbRatioControl> ratioControls;

    /**
     * 广告券 回传控制
     */
    private List<RtbSpeedControl> ticketControls;
    /**
     * 活动 回传控制
     */
    private List<RtbSpeedControl> activityControls;

    /**
     * 转化控制类型 1.cvr控制 2.扣量回传
     */
    private Byte conversionControlType;
    /**
     * 本次使用哪个 1 新的  0 老的
     */
    private Byte isUse;

    /**
     * 新的头部券逻辑
     */
    private List<PositionRtbHeadTicketGroup> newHeadList;

}