package com.bxm.adsmanager.model.dao.rtb;

import java.io.Serializable;
import java.util.Objects;

/**
 * tbl_rtb_cvr_control
 * @author 
 */
public class RtbCvrControl implements Serializable {

    public static final Byte CONTROL_TYPE_CVR = (byte) 1;
    public static final Byte CONTROL_TYPE_RATE = (byte) 2;


    private Long id;

    private String positionId;

    private String adGroupId;

    /**
     * 浅层cvr
     */
    private Double cvr;

    /**
     * 深层cvr
     */
    private Double deepCvr;

    /**
     * 开始时间，格式：HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间，格式：HH:mm:ss
     */
    private String endTime;

    /**
     * 状态：0.关闭 1.开启
     */
    private Boolean enable;

    /**
     * 控制类型：1.cvr控制 2.扣量回传
     */
    private Byte controlType;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(String adGroupId) {
        this.adGroupId = adGroupId;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Byte getControlType() {
        return controlType;
    }

    public void setControlType(Byte controlType) {
        this.controlType = controlType;
    }

    public boolean enableCvrControl() {
        return Objects.equals(this.getControlType(), CONTROL_TYPE_CVR);
    }

    public boolean enableRateControl() {
        return Objects.equals(this.getControlType(), CONTROL_TYPE_RATE);
    }

    public Double getDeepCvr() {
        return deepCvr;
    }

    public void setDeepCvr(Double deepCvr) {
        this.deepCvr = deepCvr;
    }
}