package com.bxm.adsmanager.model.dao.rtb;

import java.io.Serializable;

/**
 * tbl_rtb_ratio_control
 * @author 
 */
public class RtbRatioControl implements Serializable {
    private Long id;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 广告组 ID，一般根据不同的平台有不同的含义,为空则表示匹配当前广告位任何广告组
     */
    private String adGroupId;

    /**
     * 回传比例
     */
    private Double cvr;

    /**
     * 浅层回传比例
     */
    private Double shallowRatio;

    /**
     * 深层回传比例
     */
    private Double deepRatio;

    /**
     * <p>效果成本控制金额，单位：元，小数点保留 2 位</p>
     */
    private Double cost;

    /**
     * 开始时间，格式：HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间，格式：HH:mm:ss
     */
    private String endTime;

    /**
     * 状态：0.关闭 1.开启
     */
    private Boolean enable;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(String adGroupId) {
        this.adGroupId = adGroupId;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Double getShallowRatio() {
        return shallowRatio;
    }

    public void setShallowRatio(Double shallowRatio) {
        this.shallowRatio = shallowRatio;
    }

    public Double getDeepRatio() {
        return deepRatio;
    }

    public void setDeepRatio(Double deepRatio) {
        this.deepRatio = deepRatio;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }
}