package com.bxm.adsmanager.model.dao.user;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.io.Serializable;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * <h3>用户</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/29 14:02
 */
public class User implements Serializable {


	private static final long serialVersionUID = 1257020995526059895L;
	//id
	private String id;

	//真实姓名
	private String realname;

	//密码
	private String password;

	//用户名唯一
	private String username;
	
	/** 用户角色列表 */  
	private List<String> roleCodes;

	private String ip;
	
	public List<String> getRoleCodes() {
		return roleCodes;
	}

	public void setRoleCodes(List<String> roleCodes) {
		this.roleCodes = roleCodes;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRealname() {
		return realname;
	}

	public void setRealname(String realname) {
		this.realname = realname;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}
	
	/**  
	 * @Title: checkUserOnlyOneRole  
	 * @Description:  判断用户是否只有一个角色
	 * @author xavier  
	 * @date 2018年4月12日
	 */  
	public String getUserNameOnlyEqualRole(String roleCode){
		if (roleCodes == null || roleCodes.size() != 1) {
			return null;
		}
		if (roleCodes.get(0).equals(roleCode)) {
			return StringUtils.isNotEmpty(username) ? username : null;
		}
		return null;
	}

	/**
	 * @description 获取用户所有的角色
	 * @author hcmony
	 * @time 2018/4/25
	 * @param
	 * @return java.lang.String
	 */
	public String getUserAllRole(){

		String roleCode ="";
		if(CollectionUtils.isNotEmpty(roleCodes)){
			for (String code:roleCodes){
				roleCode +=code+",";
			}
		}else {
			roleCode = "-";
		}
		return roleCode;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	//{"id":"xx","realname":"万能测试权限","username":"万能测试权限"}

	/**
	 * @Title: getUserNameContainRole
	 * @Description:  判断用户是否存在某个角色
	 * @author 孙仲书
	 * @date 2018年5月07日
	 */

	public String getUserNameContainRole(String roleCode){
		if (roleCodes == null) {
			return null;
		}
		if (roleCodes.contains(roleCode)) {

			return StringUtils.isNotEmpty(username) ? username : null;
		}
		return null;
	}
}
