package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.List;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;

import lombok.Data;

/**
 * 广告券AppId包.</br>
 * Created by zhengwangeng on 2021/12/20
 */
@Data
public class AdAppIdPackageDTO implements Serializable {

	private static final long serialVersionUID = 8255898196234336477L;

    /**
     * ID
     */
    private Long id;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    @Length(min = 1, max = 30)
    private String name;

    /**
     * AppID列表，多个以逗号分隔
     */
    @NotBlank(message = "AppID列表不能为空，多个以逗号分隔")
    private String appIds;
}