package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotBlank;

import lombok.Data;

/**
 * 广告素材配置用户出价.</br>
 * Created by zhengwangeng on 2021/11/25
 */
@Data
public class AdAssetsConfigUidDTO implements Serializable {

	private static final long serialVersionUID = 8255898196234336477L;

    private Long id;

    /**
     * 设备号类型
     */
    @NotBlank(message = "设备号类型不能为空")
    private String deviceType;

    /**
     * 用户设备号标识
     */
    @NotBlank(message = "用户设备号标识不能为空")
    private String uid;

    /**
     * 券ID
     */
    @NotBlank(message = "券ID不能为空")
    private String ticketId;

    /**
     * 素材ID
     */
    @NotBlank(message = "素材ID不能为空")
    private String assetsId;

    /**
     * 出价CPM，单位：元
     */
    @NotNull(message = "出价CPM不能为空")
    private BigDecimal price;

}